/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.mailets;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.gateway.smtp.dsn.DSNCreator;
import org.nhindirect.gateway.util.MessageUtils;
import org.nhindirect.james.server.spring.DSNCreatorFactory;
import org.nhindirect.james.server.streams.SmtpGatewayMessageSource;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailUtils {
    private static final Logger log = LoggerFactory.getLogger(MailUtils.class);
    protected static TxDetailParser txParser = new DefaultTxDetailParser();

    public static SMTPMailMessage mailToSMTPMailMessage(Mail mail) throws MessagingException {
        if (mail == null) {
            return null;
        }
        List<Object> toAddrs = new ArrayList();
        InternetAddress fromAddr = mail.getSender() == null ? null : mail.getSender().toInternetAddress();
        Collection recips = mail.getRecipients();
        if (recips == null || recips.size() == 0) {
            Address[] recipsAddr;
            for (Address addr : recipsAddr = mail.getMessage().getAllRecipients()) {
                toAddrs.add((InternetAddress)addr);
            }
        } else {
            toAddrs = recips.stream().map(toAddr -> toAddr.toInternetAddress()).collect(Collectors.toList());
        }
        return new SMTPMailMessage(mail.getMessage(), toAddrs, fromAddr);
    }

    protected static Tx getTxToTrack(MimeMessage msg, NHINDAddress sender, NHINDAddressCollection recipients) {
        return MessageUtils.getTxToTrack((MimeMessage)msg, (NHINDAddress)sender, (NHINDAddressCollection)recipients, (TxDetailParser)txParser);
    }

    protected static void sendDSN(Tx tx, NHINDAddressCollection undeliveredRecipeints, boolean useSenderAsPostmaster) {
        try {
            Collection msgs;
            DSNCreator dsnCreator = DSNCreatorFactory.getFailedDeliverDSNCreator();
            if (dsnCreator != null && (msgs = dsnCreator.createDSNFailure(tx, undeliveredRecipeints, useSenderAsPostmaster)) != null && msgs.size() > 0) {
                for (MimeMessage msg : msgs) {
                    MailUtils.sendMessageToStream((MimeMessage)msg);
                }
            }
        }
        catch (Throwable e) {
            log.error("Error sending DSN failure message.", e);
        }
    }

    protected static void sendMessageToStream(MimeMessage msg) throws Exception {
        ImmutableList recips = (ImmutableList)Arrays.asList(msg.getAllRecipients()).stream().map(Throwing.function(MailUtils::castToMailAddress).sneakyThrow()).collect(Guavate.toImmutableList());
        MailImpl mail = MailImpl.builder().sender(MailUtils.castToMailAddress((Address)msg.getFrom()[0])).recipients((List)recips).mimeMessage(msg).build();
        SmtpGatewayMessageSource messageSource = SmtpGatewayMessageSource.getMessageSourceInstance();
        if (messageSource != null) {
            messageSource.forwardSMTPMessage(MailUtils.mailToSMTPMailMessage((Mail)mail));
        }
    }

    public static MailAddress castToMailAddress(Address address) throws AddressException {
        Preconditions.checkArgument((boolean)(address instanceof InternetAddress));
        return new MailAddress((InternetAddress)address);
    }
}

