/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.mailets;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.transport.mailets.LocalDelivery;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxMessageType;
import org.nhindirect.gateway.smtp.NotificationProducer;
import org.nhindirect.gateway.smtp.NotificationSettings;
import org.nhindirect.gateway.smtp.ReliableDispatchedNotificationProducer;
import org.nhindirect.gateway.util.MessageUtils;
import org.nhindirect.james.server.mailets.MailUtils;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.notifications.NotificationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsTimelyAndReliableLocalDelivery
extends LocalDelivery {
    private static final Logger log = LoggerFactory.getLogger(StreamsTimelyAndReliableLocalDelivery.class);
    protected static final String DISPATCHED_MDN_DELAY = "DispatchedMDNDelay";
    protected static StreamsTimelyAndReliableLocalDelivery mailetContextInstance;
    protected NotificationProducer notificationProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public StreamsTimelyAndReliableLocalDelivery(UsersRepository usersRepository, @Named(value="mailboxmanager") MailboxManager mailboxManager, MetricFactory metricFactory) {
        super(usersRepository, mailboxManager, metricFactory);
        Class<StreamsTimelyAndReliableLocalDelivery> clazz = StreamsTimelyAndReliableLocalDelivery.class;
        synchronized (StreamsTimelyAndReliableLocalDelivery.class) {
            if (usersRepository != null) {
                mailetContextInstance = this;
                StreamsTimelyAndReliableLocalDelivery.class.notifyAll();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.notificationProducer = new ReliableDispatchedNotificationProducer(new NotificationSettings(true, "Local Direct Delivery Agent", "Your message was successfully dispatched."));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mailet getStaticMailet() {
        Class<StreamsTimelyAndReliableLocalDelivery> clazz = StreamsTimelyAndReliableLocalDelivery.class;
        synchronized (StreamsTimelyAndReliableLocalDelivery.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mailetContextInstance;
        }
    }

    public void service(Mail mail) throws MessagingException {
        log.debug("Calling timely and reliable service method.");
        boolean deliverySuccessful = false;
        MimeMessage msg = mail.getMessage();
        boolean isReliableAndTimely = TxUtil.isReliableAndTimelyRequested((MimeMessage)msg);
        SMTPMailMessage smtpMailMessage = MailUtils.mailToSMTPMailMessage((Mail)mail);
        NHINDAddressCollection recipients = MessageUtils.getMailRecipients((SMTPMailMessage)smtpMailMessage);
        NHINDAddress sender = MessageUtils.getMailSender((SMTPMailMessage)smtpMailMessage);
        try {
            super.service(mail);
            deliverySuccessful = true;
        }
        catch (Exception e) {
            log.error("Failed to deliver mail locally.", (Throwable)e);
        }
        Tx txToTrack = MailUtils.getTxToTrack((MimeMessage)msg, (NHINDAddress)sender, (NHINDAddressCollection)recipients);
        if (deliverySuccessful) {
            Collection notifications;
            if (isReliableAndTimely && txToTrack.getMsgType() == TxMessageType.IMF && (notifications = this.notificationProducer.produce(new Message(msg), recipients.toInternetAddressCollection())) != null && notifications.size() > 0) {
                log.debug("Sending MDN \"dispatched\" messages");
                for (NotificationMessage message : notifications) {
                    try {
                        message.saveChanges();
                        MailUtils.sendMessageToStream((MimeMessage)message);
                    }
                    catch (Throwable t) {
                        log.error("Error sending MDN dispatched message.", t);
                    }
                }
            }
        } else if (txToTrack != null && txToTrack.getMsgType() == TxMessageType.IMF) {
            MailUtils.sendDSN((Tx)txToTrack, (NHINDAddressCollection)recipients, (boolean)false);
        }
        log.debug("Exiting timely and reliable service method.");
    }
}

