/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.mailets;

import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.james.server.mailets.MailUtils;
import org.nhindirect.james.server.streams.SmtpGatewayMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToStaAgentStream
extends GenericMailet {
    private static final Logger log = LoggerFactory.getLogger(ToStaAgentStream.class);

    public void service(Mail mail) throws MessagingException {
        log.info("Receiving message to deliver to STA.  Message id: {}", (Object)mail.getMessage().getMessageID());
        SMTPMailMessage smtpMailMessage = MailUtils.mailToSMTPMailMessage((Mail)mail);
        SmtpGatewayMessageSource messageSource = SmtpGatewayMessageSource.getMessageSourceInstance();
        if (messageSource != null) {
            messageSource.forwardSMTPMessage(smtpMailMessage);
            mail.setState("ghost");
            log.info("Message sent to STA.  Message id: {}", (Object)mail.getMessage().getMessageID());
            return;
        }
        log.warn("Message STA source is not available to process message id: {}", (Object)mail.getMessage().getMessageID());
    }
}

