/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import java.io.FileNotFoundException;
import java.util.Optional;
import org.apache.commons.configuration.Configuration;
import org.apache.james.modules.server.HealthCheckRoutesModule;
import org.apache.james.modules.server.TaskRoutesModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.utils.ConfigurationPerformer;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.PropertiesProvider;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.FixedPortSupplier;
import org.apache.james.webadmin.PortSupplier;
import org.apache.james.webadmin.TlsConfiguration;
import org.apache.james.webadmin.WebAdminConfiguration;
import org.apache.james.webadmin.WebAdminServer;
import org.apache.james.webadmin.authentication.AuthenticationFilter;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.JsonTransformerModule;
import org.nhindirect.james.server.authfilter.WebAdminBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectWebAdminServerModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(DirectWebAdminServerModule.class);
    private static final boolean DEFAULT_DISABLED = true;
    private static final String DEFAULT_NO_CORS_ORIGIN = null;
    private static final boolean DEFAULT_CORS_DISABLED = false;
    private static final String DEFAULT_NO_KEYSTORE = null;
    private static final boolean DEFAULT_HTTPS_DISABLED = false;
    private static final String DEFAULT_NO_PASSWORD = null;
    private static final String DEFAULT_NO_TRUST_KEYSTORE = null;
    private static final String DEFAULT_NO_TRUST_PASSWORD = null;

    protected void configure() {
        this.install((Module)new TaskRoutesModule());
        this.install((Module)new HealthCheckRoutesModule());
        this.bind(JsonTransformer.class).in(Scopes.SINGLETON);
        this.bind(WebAdminServer.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigurationPerformer.class).addBinding().to(WebAdminServerModule.WebAdminServerModuleConfigurationPerformer.class);
        Multibinder.newSetBinder((Binder)this.binder(), GuiceProbe.class).addBinding().to(WebAdminGuiceProbe.class);
        Multibinder.newSetBinder((Binder)this.binder(), JsonTransformerModule.class);
    }

    @Provides
    public WebAdminConfiguration provideWebAdminConfiguration(PropertiesProvider propertiesProvider) throws Exception {
        try {
            Configuration configurationFile = propertiesProvider.getConfiguration("webadmin");
            return WebAdminConfiguration.builder().enable(configurationFile.getBoolean("enabled", true)).port((PortSupplier)new FixedPortSupplier(configurationFile.getInt("port", 8080))).tls(this.readHttpsConfiguration(configurationFile)).enableCORS(configurationFile.getBoolean("cors.enable", false)).urlCORSOrigin(configurationFile.getString("cors.origin", DEFAULT_NO_CORS_ORIGIN)).host(configurationFile.getString("host", "localhost")).build();
        }
        catch (FileNotFoundException e) {
            log.info("No webadmin.properties file. Disabling WebAdmin interface.");
            return WebAdminConfiguration.DISABLED_CONFIGURATION;
        }
    }

    @Provides
    public AuthenticationFilter providesAuthenticationFilter(PropertiesProvider propertiesProvider) throws Exception {
        Configuration configurationFile = propertiesProvider.getConfiguration("webadmin");
        return new WebAdminBasicAuthFilter(configurationFile.getString("username"), configurationFile.getString("password"));
    }

    private Optional<TlsConfiguration> readHttpsConfiguration(Configuration configurationFile) {
        boolean enabled = configurationFile.getBoolean("https.enabled", false);
        if (enabled) {
            return Optional.of(TlsConfiguration.builder().raw(configurationFile.getString("https.keystore", DEFAULT_NO_KEYSTORE), configurationFile.getString("https.password", DEFAULT_NO_PASSWORD), configurationFile.getString("https.trust.keystore", DEFAULT_NO_TRUST_KEYSTORE), configurationFile.getString("https.trust.password", DEFAULT_NO_TRUST_PASSWORD)).build());
        }
        return Optional.empty();
    }
}

