/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.spring;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.GuiceJamesServer;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.activemq.ActiveMQQueueModule;
import org.apache.james.modules.data.SieveJPARepositoryModules;
import org.apache.james.modules.mailbox.DefaultEventModule;
import org.apache.james.modules.mailbox.JPAMailboxModule;
import org.apache.james.modules.mailbox.LuceneSearchMailboxModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.DefaultProcessorsConfigurationProviderModule;
import org.apache.james.modules.server.ElasticSearchMetricReporterModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.NoJwtModule;
import org.apache.james.modules.server.RawPostDequeueDecoratorModule;
import org.apache.james.modules.server.ReIndexingModule;
import org.apache.james.modules.server.SieveQuotaRoutesModule;
import org.apache.james.modules.server.SwaggerRoutesModule;
import org.apache.james.modules.spamassassin.SpamAssassinListenerModule;
import org.apache.james.server.core.configuration.Configuration;
import org.nhind.config.rest.AddressService;
import org.nhind.config.rest.DomainService;
import org.nhindirect.config.model.Domain;
import org.nhindirect.james.server.modules.DirectWebAdminServerModule;
import org.nhindirect.james.server.modules.HybridDataModule;
import org.nhindirect.james.server.modules.RESTDataServiceModule;
import org.parboiled.common.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@org.springframework.context.annotation.Configuration
public class JamesServerConfig {
    private static final Logger log = LoggerFactory.getLogger(JamesServerConfig.class);
    public static final String DEFAULT_MAILET_CONFIG = "/properties/mailetcontainer.xml";
    public static final String DEFAULT_IMAP_CONFIG = "/properties/imapserver.xml";
    public static final String DEFAULT_POP3_CONFIG = "/properties/pop3server.xml";
    public static final String DEFAULT_SMTP_CONFIG = "/properties/smtpserver.xml";
    public static final String DEFAULT_KEYSTORE = "/properties/keystore";
    @Value(value="${spring.datasource.driver-class-name}")
    protected String driverClassName;
    @Value(value="${spring.datasource.url}")
    protected String datasourceUrl;
    @Value(value="${spring.datasource.username}")
    protected String datasourceUserName;
    @Value(value="${spring.datasource.password}")
    protected String datasourcePassword;
    @Value(value="${spring.datasource.adapter}")
    protected String datasourceAdapter;
    @Value(value="${spring.datasource.streaming}")
    protected String datasourceStreaming;
    @Value(value="${james.server.webadmin.enabled:true}")
    protected String enableWebAdmin;
    @Value(value="${james.server.webadmin.port:8080}")
    protected String webAdminPort;
    @Value(value="${james.server.webadmin.username}")
    protected String webAdminUser;
    @Value(value="${james.server.webadmin.password}")
    protected String webAdminPassword;
    @Value(value="${james.server.webadmin.https.tlsenabled:false}")
    protected String webadminTlsEnabled;
    @Value(value="${james.server.webadmin.https.keystore:}")
    protected String webAdminKeystore;
    @Value(value="${james.server.webadmin.https.keystorePassword:}")
    protected String webAdminKeystorePassword;
    @Value(value="${james.server.webadmin.https.trust.keystore:}")
    protected String webAdminTrustKeystore;
    @Value(value="${james.server.webadmin.https.trust.keystorePassword:}")
    protected String webAdminTrustKeystorePassword;
    @Value(value="${james.server.imap.bind:0.0.0.0}")
    protected String imapBind;
    @Value(value="${james.server.imap.port:1143}")
    protected String imapPort;
    @Value(value="${james.server.imap.sockettls:false}")
    protected String imapSocketTLS;
    @Value(value="${james.server.imap.starttls:true}")
    protected String imapStartTLS;
    @Value(value="${james.server.imap.keystore:}")
    protected String imapKeyStore;
    @Value(value="${james.server.imap.keystorePassword:1kingpuff}")
    protected String imapKeyStorePassword;
    @Value(value="${james.server.pop3.bind:0.0.0.0}")
    protected String pop3Bind;
    @Value(value="${james.server.pop3.port:1110}")
    protected String pop3Port;
    @Value(value="${james.server.pop3.sockettls:false}")
    protected String pop3SocketTLS;
    @Value(value="${james.server.pop3.starttls:true}")
    protected String pop3StartTLS;
    @Value(value="${james.server.pop3.keystore:}")
    protected String pop3KeyStore;
    @Value(value="${james.server.pop3.keystorePassword:1kingpuff}")
    protected String pop3KeyStorePassword;
    @Value(value="${james.server.smtp.bind:0.0.0.0}")
    protected String smtpBind;
    @Value(value="${james.server.smtp.port:1587}")
    protected String smtpPort;
    @Value(value="${james.server.smtp.sockettls:false}")
    protected String smtpSocketTLS;
    @Value(value="${james.server.smtp.starttls:true}")
    protected String smtpStartTLS;
    @Value(value="${james.server.smtp.keystore:}")
    protected String smtpKeyStore;
    @Value(value="${james.server.smtp.keystorePassword:1kingpuff}")
    protected String smtpKeyStorePassword;
    @Value(value="${james.server.smtp.autoAddresses:127.0.0.0/8}")
    protected String smtpAuthAddresses;
    @Value(value="${james.server.config.mailet.configFile:}")
    protected String mailetConfigFile;
    @Value(value="${james.server.config.imap.configFile:}")
    protected String imapConfigFile;
    @Value(value="${james.server.config.pop3.configFile:}")
    protected String pop3ConfigFile;
    @Value(value="${james.server.config.smtp.configFile:}")
    protected String smtpConfigFile;
    @Autowired
    protected DomainService domService;
    public static final Module PROTOCOLS;
    public static final Module JPA_SERVER_MODULE;
    public static final Module JPA_MODULE_AGGREGATE;
    public static final Module WEBADMIN;

    @Bean
    @ConditionalOnMissingBean
    public GuiceJamesServer jamesServer(DomainService domService, AddressService addrService) throws Exception {
        this.writeJPAConfig();
        this.writeWebAdminConfig();
        this.writeDomainListConfig();
        this.writeMailetConfig();
        this.writeIMAPConfig();
        this.writePOP3Config();
        this.writeSMTPConfig();
        this.writeUserRepositoryConfig();
        Configuration configuration = Configuration.builder().workingDirectory(".").build();
        GuiceJamesServer server = GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{JPA_MODULE_AGGREGATE, new JMXServerModule(), new RESTDataServiceModule(domService, addrService)});
        server.start();
        return server;
    }

    protected void writeJPAConfig() throws Exception {
        File file = new File("conf/james-database.properties");
        String dbPropString = IOUtils.resourceToString((String)"/properties/james-database.properties", (Charset)Charset.defaultCharset());
        dbPropString = dbPropString.replace("${driver}", this.driverClassName);
        dbPropString = dbPropString.replace("${url}", this.datasourceUrl);
        dbPropString = dbPropString.replace("${username}", this.datasourceUserName);
        dbPropString = dbPropString.replace("${password}", this.datasourcePassword);
        dbPropString = dbPropString.replace("${dbadapter}", this.datasourceAdapter);
        dbPropString = dbPropString.replace("${streaming}", this.datasourceStreaming);
        FileUtils.writeAllText((String)dbPropString, (File)file);
    }

    protected void writeWebAdminConfig() throws Exception {
        File file = new File("conf/webadmin.properties");
        String webAdminString = IOUtils.resourceToString((String)"/properties/webadmin.properties", (Charset)Charset.defaultCharset());
        webAdminString = webAdminString.replace("${enabled}", this.enableWebAdmin);
        webAdminString = webAdminString.replace("${port}", this.webAdminPort);
        webAdminString = webAdminString.replace("${username}", this.webAdminUser);
        webAdminString = webAdminString.replace("${password}", this.webAdminPassword);
        webAdminString = webAdminString.replace("${httpsEnabled}", this.webadminTlsEnabled);
        webAdminString = webAdminString.replace("${keystore}", this.webAdminKeystore);
        webAdminString = webAdminString.replace("${keystorePassword}", this.webAdminKeystorePassword);
        webAdminString = webAdminString.replace("${trustKeystore}", this.webAdminTrustKeystore);
        webAdminString = webAdminString.replace("${trustPassword}", this.webAdminTrustKeystorePassword);
        FileUtils.writeAllText((String)webAdminString, (File)file);
    }

    protected void writeUserRepositoryConfig() throws Exception {
        File file = new File("conf/usersrepository.xml");
        String userRepositoryXML = IOUtils.resourceToString((String)"/properties/userrepository.xml", (Charset)Charset.defaultCharset());
        FileUtils.writeAllText((String)userRepositoryXML, (File)file);
    }

    protected void writeDomainListConfig() throws Exception {
        File file = new File("conf/domainlist.xml");
        String domainlistXML = IOUtils.resourceToString((String)"/properties/domainlist.xml", (Charset)Charset.defaultCharset());
        StringBuilder domListBuilder = new StringBuilder();
        Collection domains = this.domService.searchDomains("", null);
        if (domains.isEmpty()) {
            log.warn("No domains defined.  A default list will be injected by James.");
            return;
        }
        for (Domain domain : domains) {
            domListBuilder.append("<domain>").append(domain.getDomainName()).append("</domain>\r\n");
        }
        domainlistXML = domainlistXML.replace("${domainnames}", domListBuilder.toString());
        domainlistXML = domainlistXML.replace("${defaultdomain}", ((Domain)domains.iterator().next()).getDomainName());
        FileUtils.writeAllText((String)domainlistXML, (File)file);
    }

    protected void writeMailetConfig() throws Exception {
        File writeFile = new File("conf/mailetcontainer.xml");
        byte[] content = StringUtils.isEmpty((CharSequence)this.mailetConfigFile) ? IOUtils.resourceToByteArray((String)DEFAULT_MAILET_CONFIG) : FileUtils.readAllBytes((File)new File(this.mailetConfigFile));
        FileUtils.writeAllBytes((byte[])content, (File)writeFile);
    }

    protected void writeIMAPConfig() throws Exception {
        File configFile = new File("conf/imapserver.xml");
        String content = StringUtils.isEmpty((CharSequence)this.imapConfigFile) ? IOUtils.resourceToString((String)DEFAULT_IMAP_CONFIG, (Charset)Charset.defaultCharset()) : FileUtils.readAllText((File)new File(this.imapConfigFile));
        content = content.replace("${bind}", this.imapBind);
        content = content.replace("${port}", this.imapPort);
        content = content.replace("${socketTLS}", this.imapSocketTLS);
        content = content.replace("${startTLS}", this.imapStartTLS);
        content = content.replace("${keystorePassword}", this.imapKeyStorePassword);
        FileUtils.writeAllText((String)content, (File)configFile);
        File keystoreFile = new File("conf/keystore");
        byte[] keyStoreContent = StringUtils.isEmpty((CharSequence)this.imapKeyStore) ? IOUtils.resourceToByteArray((String)DEFAULT_KEYSTORE) : FileUtils.readAllBytes((File)new File(this.imapKeyStore));
        FileUtils.writeAllBytes((byte[])keyStoreContent, (File)keystoreFile);
    }

    protected void writePOP3Config() throws Exception {
        File configFile = new File("conf/pop3server.xml");
        String content = StringUtils.isEmpty((CharSequence)this.pop3ConfigFile) ? IOUtils.resourceToString((String)DEFAULT_POP3_CONFIG, (Charset)Charset.defaultCharset()) : FileUtils.readAllText((File)new File(this.pop3ConfigFile));
        content = content.replace("${bind}", this.pop3Bind);
        content = content.replace("${port}", this.pop3Port);
        content = content.replace("${socketTLS}", this.pop3SocketTLS);
        content = content.replace("${startTLS}", this.pop3StartTLS);
        content = content.replace("${keystorePassword}", this.pop3KeyStorePassword);
        FileUtils.writeAllText((String)content, (File)configFile);
        File keystoreFile = new File("conf/keystore");
        byte[] keyStoreContent = StringUtils.isEmpty((CharSequence)this.pop3KeyStore) ? IOUtils.resourceToByteArray((String)DEFAULT_KEYSTORE) : FileUtils.readAllBytes((File)new File(this.pop3KeyStore));
        FileUtils.writeAllBytes((byte[])keyStoreContent, (File)keystoreFile);
    }

    protected void writeSMTPConfig() throws Exception {
        File configFile = new File("conf/smtpserver.xml");
        String content = StringUtils.isEmpty((CharSequence)this.smtpConfigFile) ? IOUtils.resourceToString((String)DEFAULT_SMTP_CONFIG, (Charset)Charset.defaultCharset()) : FileUtils.readAllText((File)new File(this.smtpConfigFile));
        content = content.replace("${bind}", this.smtpBind);
        content = content.replace("${port}", this.smtpPort);
        content = content.replace("${socketTLS}", this.smtpSocketTLS);
        content = content.replace("${startTLS}", this.smtpStartTLS);
        content = content.replace("${keystorePassword}", this.smtpKeyStorePassword);
        content = content.replace("${authAddresses}", this.smtpAuthAddresses);
        FileUtils.writeAllText((String)content, (File)configFile);
        File keystoreFile = new File("conf/keystore");
        byte[] keyStoreContent = StringUtils.isEmpty((CharSequence)this.smtpKeyStore) ? IOUtils.resourceToByteArray((String)DEFAULT_KEYSTORE) : FileUtils.readAllBytes((File)new File(this.smtpKeyStore));
        FileUtils.writeAllBytes((byte[])keyStoreContent, (File)keystoreFile);
    }

    static {
        WEBADMIN = Modules.combine((Module[])new Module[]{new DirectWebAdminServerModule(), new DataRoutesModules(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new SwaggerRoutesModule(), new SieveQuotaRoutesModule(), new ReIndexingModule()});
        PROTOCOLS = Modules.combine((Module[])new Module[]{new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), WEBADMIN});
        JPA_SERVER_MODULE = Modules.combine((Module[])new Module[]{new ActiveMQQueueModule(), new DefaultProcessorsConfigurationProviderModule(), new ElasticSearchMetricReporterModule(), new HybridDataModule(), new JPAMailboxModule(), new MailboxModule(), new LuceneSearchMailboxModule(), new NoJwtModule(), new RawPostDequeueDecoratorModule(), new SieveJPARepositoryModules(), new DefaultEventModule(), new SpamAssassinListenerModule()});
        JPA_MODULE_AGGREGATE = Modules.combine((Module[])new Module[]{JPA_SERVER_MODULE, PROTOCOLS});
    }
}

