/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.streams;

import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.mail.streams.SMTPMailMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.stereotype.Component;

@Component
public class SmtpGatewayMessageSource {
    protected static SmtpGatewayMessageSource messageSourceInstance;
    protected static final String OUT_BINDING_NAME = "direct-smtp-gateway-message-out-0";
    @Autowired
    private StreamBridge streamBridge;

    public SmtpGatewayMessageSource() {
        messageSourceInstance = this;
    }

    public <T> void forwardSMTPMessage(SMTPMailMessage msg) {
        this.streamBridge.send(OUT_BINDING_NAME, (Object)SMTPMailMessageConverter.toStreamMessage((SMTPMailMessage)msg));
    }

    public static SmtpGatewayMessageSource getMessageSourceInstance() {
        return messageSourceInstance;
    }
}

