/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.james.server.streams.sinks;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.nhindirect.common.mail.SMTPMailMessage;
import org.nhindirect.common.mail.streams.SMTPMailMessageConverter;
import org.nhindirect.james.server.mailets.MailUtils;
import org.nhindirect.james.server.mailets.StreamsTimelyAndReliableLocalDelivery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;

@Configuration
public class STALastMileDeliverySink {
    private static final Logger log = LoggerFactory.getLogger(STALastMileDeliverySink.class);

    @Bean
    public Consumer<Message<?>> directStaLastMileInput() {
        return streamMsg -> {
            Class<StreamsTimelyAndReliableLocalDelivery> clazz = StreamsTimelyAndReliableLocalDelivery.class;
            synchronized (StreamsTimelyAndReliableLocalDelivery.class) {
                if (StreamsTimelyAndReliableLocalDelivery.getStaticMailet() == null) {
                    try {
                        STALastMileDeliverySink.class.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                SMTPMailMessage smtpMessage = SMTPMailMessageConverter.fromStreamMessage((Message)streamMsg);
                ImmutableList recips = (ImmutableList)smtpMessage.getRecipientAddresses().stream().map(Throwing.function(MailUtils::castToMailAddress).sneakyThrow()).collect(Guavate.toImmutableList());
                try {
                    MailImpl mail = MailImpl.builder().sender(new MailAddress(smtpMessage.getMailFrom())).recipients((List)recips).mimeMessage(smtpMessage.getMimeMessage()).build();
                    log.info("Processing last mile delivery for from {} to {} with message id {}", new Object[]{smtpMessage.getMailFrom().toString(), this.toRecipsPrettingString(recips), smtpMessage.getMimeMessage().getMessageID()});
                    StreamsTimelyAndReliableLocalDelivery.getStaticMailet().service((Mail)mail);
                }
                catch (MessagingException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        };
    }

    protected String toRecipsPrettingString(ImmutableList<MailAddress> recips) {
        CharSequence[] addrs = new String[recips.size()];
        int idx = 0;
        for (MailAddress addr : recips) {
            addrs[idx++] = addr.asPrettyString();
        }
        return String.join((CharSequence)",", addrs);
    }
}

