/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.tx.BaseTestPlan;
import org.nhindirect.common.tx.SpringBaseTest;
import org.nhindirect.common.tx.TestUtils;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class RESTTxServiceClient_addTxTest
extends SpringBaseTest {
    @Test
    public void testSingle_assertTxReceived() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected void trackMessage(Tx tx) throws Exception {
                RESTTxServiceClient_addTxTest.this.client.trackMessage(tx);
            }

            @Override
            protected Collection<Tx> getTxsToSubmit() {
                ArrayList<Tx> txs = new ArrayList<Tx>();
                String originalMessageId = UUID.randomUUID().toString();
                Tx originalMessage = TestUtils.makeMessage(TxMessageType.IMF, originalMessageId, "", "gm2552@cerner.com", "gm2552@direct.securehealthemail.com", "");
                txs.add(originalMessage);
                return txs;
            }

            @Override
            protected void doAssertions(Collection<Tx> txs) throws Exception {
                Assert.assertEquals((long)1L, (long)txs.size());
                Assert.assertEquals((Object)TxMessageType.IMF, (Object)txs.iterator().next().getMsgType());
            }
        }.perform();
    }

    @Test
    public void testSendMimeMessage_assertTxsReceived() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected Collection<MimeMessage> getTxsToSubmit() {
                ArrayList<MimeMessage> txs = new ArrayList<MimeMessage>();
                try {
                    MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
                    txs.add(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return txs;
            }

            @Override
            protected void trackMessage(MimeMessage tx) throws Exception {
                RESTTxServiceClient_addTxTest.this.client.trackMessage(tx);
            }

            @Override
            protected void doAssertions(Collection<Tx> txs) throws Exception {
                Assert.assertEquals((long)1L, (long)txs.size());
            }
        }.perform();
    }

    @Test
    public void testSendMimeMessage_friendlyFinalRecipName_assertTxsReceived() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected Collection<MimeMessage> getTxsToSubmit() {
                ArrayList<MimeMessage> txs = new ArrayList<MimeMessage>();
                try {
                    MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessageFriendlyNameFinalRecip.txt");
                    txs.add(msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return txs;
            }

            @Override
            protected void trackMessage(MimeMessage tx) throws Exception {
                RESTTxServiceClient_addTxTest.this.client.trackMessage(tx);
            }

            @Override
            protected void doAssertions(Collection<Tx> txs) throws Exception {
                Assert.assertEquals((long)1L, (long)txs.size());
                Tx tx = txs.iterator().next();
                Assert.assertEquals((Object)"externaluser <externuser1@starugh-stateline.com>", (Object)tx.getDetail(TxDetailType.FINAL_RECIPIENTS).getDetailValue());
            }
        }.perform();
    }

    @Test
    public void testSendInputStream_assertTxsReceived() throws Exception {
        new TestPlan<InternetHeaders>(){

            @Override
            protected Collection<InternetHeaders> getTxsToSubmit() {
                ArrayList<InternetHeaders> txs = new ArrayList<InternetHeaders>();
                try {
                    InputStream inStr = IOUtils.toInputStream((String)TestUtils.readMessageFromFile("MessageWithAttachment.txt"));
                    InternetHeaders headers = new InternetHeaders(inStr);
                    txs.add(headers);
                    IOUtils.closeQuietly((InputStream)inStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return txs;
            }

            @Override
            protected void trackMessage(InternetHeaders tx) throws Exception {
                RESTTxServiceClient_addTxTest.this.client.trackMessage(tx);
            }

            @Override
            protected void doAssertions(Collection<Tx> txs) throws Exception {
                Assert.assertEquals((long)1L, (long)txs.size());
            }
        }.perform();
    }

    abstract class TestPlan<T>
    extends BaseTestPlan {
        TestPlan() {
        }

        @Override
        protected void tearDownMocks() {
            if (RESTTxServiceClient_addTxTest.this.resource != null) {
                RESTTxServiceClient_addTxTest.this.resource.clearTxState();
            }
        }

        protected Collection<T> getTxsToSubmit() {
            return Collections.emptyList();
        }

        @Override
        protected void performInner() throws Exception {
            Collection<T> txs = this.getTxsToSubmit();
            if (txs != null) {
                for (T tx : txs) {
                    this.trackMessage(tx);
                }
            }
            this.doAssertions(RESTTxServiceClient_addTxTest.this.resource.getTxs());
        }

        protected void doAssertions(Collection<Tx> txs) throws Exception {
        }

        protected abstract void trackMessage(T var1) throws Exception;
    }
}

