/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.common.tx.BaseTestPlan;
import org.nhindirect.common.tx.SpringBaseTest;
import org.nhindirect.common.tx.TestUtils;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;

public class RESTTxServiceClient_suppressNotificationTest
extends SpringBaseTest {
    @Test
    public void testNonNotificationMessage_assertFalse() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected boolean suppressNotification(MimeMessage tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected MimeMessage getNotficationSubmit() throws Exception {
                return TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertFalse((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testMDNNotificationMessage_assertTrue() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected boolean suppressNotification(MimeMessage tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected MimeMessage getNotficationSubmit() throws Exception {
                return TestUtils.readMimeMessageFromFile("MDNMessage.txt");
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertTrue((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testDSNNotificationMessage_assertTrue() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected boolean suppressNotification(MimeMessage tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected MimeMessage getNotficationSubmit() throws Exception {
                return TestUtils.readMimeMessageFromFile("DSNMessage.txt");
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertTrue((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testNullNotificationMessage_assertException() throws Exception {
        new TestPlan<MimeMessage>(){

            @Override
            protected boolean suppressNotification(MimeMessage tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected MimeMessage getNotficationSubmit() throws Exception {
                return null;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((exception != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    @Test
    public void testEmptyOriginalMessageId_assertFalse() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected boolean suppressNotification(Tx tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected Tx getNotficationSubmit() throws Exception {
                MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
                Map details = new DefaultTxDetailParser().getMessageDetails(msg);
                details.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID, ""));
                Tx tx = new Tx(TxUtil.getMessageType((MimeMessage)msg), details);
                return tx;
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertFalse((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testNullOriginalMessageId_assertFalse() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected boolean suppressNotification(Tx tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected Tx getNotficationSubmit() throws Exception {
                MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
                Map details = new DefaultTxDetailParser().getMessageDetails(msg);
                details.remove(TxDetailType.PARENT_MSG_ID.getType());
                Tx tx = new Tx(TxUtil.getMessageType((MimeMessage)msg), details);
                return tx;
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertFalse((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testNullTx_assertException() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected boolean suppressNotification(Tx tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected Tx getNotficationSubmit() throws Exception {
                return null;
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((exception != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    @Test
    public void testNotNotificationString_assertFalse() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected boolean suppressNotification(Tx tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected Tx getNotficationSubmit() throws Exception {
                MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
                Map details = new DefaultTxDetailParser().getMessageDetails(msg);
                details.put(TxDetailType.PARENT_MSG_ID.getType(), new TxDetail(TxDetailType.PARENT_MSG_ID, "NotNotification"));
                Tx tx = new Tx(TxUtil.getMessageType((MimeMessage)msg), details);
                return tx;
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertFalse((boolean)b);
            }
        }.perform();
    }

    @Test
    public void testNotificationMessageIdString_assertTrue() throws Exception {
        new TestPlan<Tx>(){

            @Override
            protected boolean suppressNotification(Tx tx) throws Exception {
                return RESTTxServiceClient_suppressNotificationTest.this.client.suppressNotification(tx);
            }

            @Override
            protected Tx getNotficationSubmit() throws Exception {
                MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
                Map details = new DefaultTxDetailParser().getMessageDetails(msg);
                Tx tx = new Tx(TxUtil.getMessageType((MimeMessage)msg), details);
                return tx;
            }

            @Override
            protected void doAssertions(boolean b) throws Exception {
                Assert.assertTrue((boolean)b);
            }
        }.perform();
    }

    abstract class TestPlan<T>
    extends BaseTestPlan {
        TestPlan() {
        }

        @Override
        protected void tearDownMocks() {
            if (RESTTxServiceClient_suppressNotificationTest.this.resource != null) {
                RESTTxServiceClient_suppressNotificationTest.this.resource.clearTxState();
            }
        }

        protected T getNotficationSubmit() throws Exception {
            return null;
        }

        @Override
        protected void performInner() throws Exception {
            boolean b = false;
            T tx = this.getNotficationSubmit();
            b = this.suppressNotification(tx);
            this.doAssertions(b);
        }

        protected void doAssertions(boolean b) throws Exception {
        }

        protected abstract boolean suppressNotification(T var1) throws Exception;
    }
}

