/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.impl.TxParseUtils;
import org.nhindirect.common.tx.model.Tx;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"txs"})
public class MockTxsResource {
    protected Collection<Tx> txs = new ArrayList<Tx>();
    protected static final CacheControl noCache = CacheControl.noCache();

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Void> addTx(@RequestBody Tx tx) {
        this.txs.add(tx);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CREATED).cacheControl(noCache)).build();
    }

    @PostMapping(value={"suppressNotification"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Boolean> supressNotification(@RequestBody Tx notificationMessage) {
        Boolean retEntity = Boolean.TRUE;
        String originalMessageId = TxParseUtils.getOriginalMessageId((Tx)notificationMessage, (TxDetailParser)new DefaultTxDetailParser());
        if (originalMessageId.isEmpty() || originalMessageId.equals("NotNotification")) {
            retEntity = Boolean.FALSE;
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retEntity);
    }

    public void clearTxState() {
        this.txs.clear();
    }

    public Collection<Tx> getTxs() {
        return Collections.unmodifiableCollection(this.txs);
    }
}

