/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tx.TxDetailParser;
import org.nhindirect.common.tx.TxService;
import org.nhindirect.common.tx.impl.TxParseUtils;
import org.nhindirect.common.tx.impl.feign.TxClient;
import org.nhindirect.common.tx.model.Tx;
import org.springframework.stereotype.Component;

@Component
public class RESTTxServiceClient
implements TxService {
    protected TxClient txClient;
    protected final TxDetailParser parser;

    public RESTTxServiceClient(TxClient txClient, TxDetailParser parser) {
        this.txClient = txClient;
        this.parser = parser;
    }

    @Override
    public void trackMessage(MimeMessage msg) throws ServiceException {
        this.txClient.addTx(TxParseUtils.convertMimeMessageToTx(msg, this.parser));
    }

    @Override
    public void trackMessage(InternetHeaders headers) throws ServiceException {
        this.txClient.addTx(TxParseUtils.convertMimeMessageToTx(TxParseUtils.convertHeadersToMessage(headers, this.parser), this.parser));
    }

    @Override
    public void trackMessage(Tx tx) throws ServiceException {
        this.txClient.addTx(tx);
    }

    @Override
    public boolean suppressNotification(MimeMessage msg) throws ServiceException {
        return this.txClient.supressNotification(TxParseUtils.convertMimeMessageToTx(msg, this.parser));
    }

    @Override
    public boolean suppressNotification(Tx notificationMessage) throws ServiceException {
        return this.txClient.supressNotification(notificationMessage);
    }
}

