/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx;

import java.util.HashMap;
import javax.mail.internet.MimeMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.TestUtils;
import org.nhindirect.common.tx.TxUtil;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class TxUtil_isRelAndTimelyTest {
    @Test
    public void testIsTimelyAndRequired_nullMessage_assertFalse() {
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((Tx)null));
    }

    @Test
    public void testIsTimelyAndRequired_nullMimeMessage_assertFalse() {
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((MimeMessage)null));
    }

    @Test
    public void testIsTimelyAndRequired_emptyDetails_assertFalse() {
        Tx msg = new Tx(TxMessageType.IMF, new HashMap());
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((Tx)msg));
    }

    @Test
    public void testIsTimelyAndRequired_NoMNDOptionDetails_assertFalse() {
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((Tx)msg));
    }

    @Test
    public void testIsTimelyAndRequired_MDNOptionNotForTimely_assertFalse() {
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS, "X-NOT-TIMELY"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((Tx)msg));
    }

    @Test
    public void testIsTimelyAndRequired_MDNOptionForTimely_assertTrue() {
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS, "X-DIRECT-FINAL-DESTINATION-DELIVERY"));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertTrue((boolean)TxUtil.isReliableAndTimelyRequested((Tx)msg));
    }

    @Test
    public void testIsTimelyAndRequired_caseInsensitiveOption_MDNOptionForTimely_assertTrue() {
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.DISPOSITION_OPTIONS.getType(), new TxDetail(TxDetailType.DISPOSITION_OPTIONS, "X-DIRECT-FINAL-DESTINATION-DELIVERY".toLowerCase()));
        Tx msg = new Tx(TxMessageType.IMF, details);
        Assertions.assertTrue((boolean)TxUtil.isReliableAndTimelyRequested((Tx)msg));
    }

    @Test
    public void testIsTimelyAndRequired_MDNOptionForTimelyMimeMessage_assertTrue() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.addHeader("Disposition-Notification-Options", "X-DIRECT-FINAL-DESTINATION-DELIVERY");
        msg.saveChanges();
        Assertions.assertTrue((boolean)TxUtil.isReliableAndTimelyRequested((MimeMessage)msg));
    }

    @Test
    public void testIsTimelyAndRequired_NoMDNOptionForTimelyMimeMessage_assertFalse() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        Assertions.assertFalse((boolean)TxUtil.isReliableAndTimelyRequested((MimeMessage)msg));
    }
}

