/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.mail.MailStandard;
import org.nhindirect.common.tx.TestUtils;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;

public class DefaultTxDetailParser_getMessageDetails_OptionalInputsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMessageDetailsFromInputStream_getDetailsFromCommonMessage() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        InputStream inStream = IOUtils.toInputStream((String)TestUtils.readMessageFromFile("MessageWithAttachment.txt"));
        try {
            DefaultTxDetailParser parser = new DefaultTxDetailParser();
            Map details = parser.getMessageDetails(inStream);
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
        }
    }

    @Test
    public void testGetMessageDetailsFromInputStream_nullStream_assertException() throws Exception {
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        boolean exceptionOccured = false;
        try {
            parser.getMessageDetails((InputStream)null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMessageDetailsFromHeaders_getDetailsFromCommonMessage() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        InputStream inStream = IOUtils.toInputStream((String)TestUtils.readMessageFromFile("MessageWithAttachment.txt"));
        try {
            InternetHeaders headers = new InternetHeaders(inStream);
            DefaultTxDetailParser parser = new DefaultTxDetailParser();
            Map details = parser.getMessageDetails(headers);
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
            Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
        }
        finally {
            IOUtils.closeQuietly((InputStream)inStream);
        }
    }

    @Test
    public void testGetMessageDetails_getReportExtension_dispostionOption() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNDispatchedTimeAndReliable.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject"), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
        Assertions.assertEquals((Object)"X-DIRECT-FINAL-DESTINATION-DELIVERY", (Object)((TxDetail)details.get(TxDetailType.DISPOSITION_OPTIONS.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_getReportExtension_lowercaseOption_assertdispostionOption() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNDispatchedTimeAndReliableLowerCaseOption.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject"), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
        Assertions.assertEquals((Object)"X-DIRECT-FINAL-DESTINATION-DELIVERY", (Object)((TxDetail)details.get(TxDetailType.DISPOSITION_OPTIONS.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_getReportExtension_noDispostionOption() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.DISPOSITION_OPTIONS.getType()));
    }
}

