/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.impl;

import java.util.Locale;
import java.util.Map;
import javax.mail.internet.MimeMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.mail.MDNStandard;
import org.nhindirect.common.mail.MailStandard;
import org.nhindirect.common.tx.TestUtils;
import org.nhindirect.common.tx.impl.DefaultTxDetailParser;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;

public class DefaultTxDetailParser_getMimeMessageDetailsTest {
    @Test
    public void testGetMessageDetails_getDetailsFromCommonMessage() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_noMessageId() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("message-id", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.MSG_ID.getType()));
    }

    @Test
    public void testGetMessageDetails_noSubject() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("subject", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.SUBJECT.getType()));
    }

    @Test
    public void testGetMessageDetails_noFullHeaders() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser(){

            public String getHeadersAsStringInternal(MimeMessage msg) {
                return "";
            }
        };
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.MSG_FULL_HEADERS.getType()));
    }

    @Test
    public void testGetMessageDetails_noFrom() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("from", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.FROM.getType()));
    }

    @Test
    public void testGetMessageDetails_mutlipleFroms() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("from", "gm2552@cerner.com,ah4626@cerner.com");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_noSender() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.SENDER.getType()));
    }

    @Test
    public void testGetMessageDetails_senderExists() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("sender", "gm2552@cerner.com");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"sender").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.SENDER.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_mutlipleTo() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("to", "gm2552@cerner.com,ah4626@cerner.com");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_ToAndCC() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("to", "gm2552@cerner.com");
        msg.setHeader("cc", "ah4626@cerner.com");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)"gm2552@cerner.com,ah4626@cerner.com", (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_generalMDNMessage() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessage.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Disposition").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.DISPOSITION.getType())).getDetailValue());
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Final-Recipient").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FINAL_RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Original-Message-ID"), (Object)((TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_generalMDNMessage_noOrigMessageId_getFromReplyTo() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessageOrigInReplyTo.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Disposition").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.DISPOSITION.getType())).getDetailValue());
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Final-Recipient").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FINAL_RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"in-reply-to"), (Object)((TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_generalMDNMessage_noOrigMessageId() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessageOrigInReplyTo.txt");
        msg.setHeader("in-reply-to", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Disposition").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.DISPOSITION.getType())).getDetailValue());
        Assertions.assertEquals((Object)MDNStandard.getMDNField((MimeMessage)msg, (String)"Final-Recipient").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FINAL_RECIPIENTS.getType())).getDetailValue());
        Assertions.assertNull(details.get(TxDetailType.PARENT_MSG_ID.getType()));
    }

    @Test
    public void testGetMessageDetails_noDisposition() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessageNoDisp.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.DISPOSITION.getType()));
    }

    @Test
    public void testGetMessageDetails_noFinalRecipient() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MDNMessageNoFinalRecip.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.FINAL_RECIPIENTS.getType()));
    }

    @Test
    public void testGetMessageDetails_generalDNSMessage() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("DSNMessage.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)"failed", (Object)((TxDetail)details.get(TxDetailType.DSN_ACTION.getType())).getDetailValue());
        Assertions.assertEquals((Object)"5.0.0", (Object)((TxDetail)details.get(TxDetailType.DSN_STATUS.getType())).getDetailValue());
        Assertions.assertEquals((Object)"Carol@Ivory.EDU".toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FINAL_RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)"<9501051053.aa04167@IETF.CNR I.Reston.VA.US>", (Object)((TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_generalDNSMessage_noOrigMessageId_getFromReplyTo() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("DSNMessageOrigInReplyTo.txt");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)"<9501051053.aa04167@IETF.CNR I.Reston.VA.US>", (Object)((TxDetail)details.get(TxDetailType.PARENT_MSG_ID.getType())).getDetailValue());
    }

    @Test
    public void testGetMessageDetails_generalDNSMessage_noOrigMessageId() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("DSNMessageOrigInReplyTo.txt");
        msg.setHeader("in-reply-to", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.PARENT_MSG_ID.getType()));
    }

    @Test
    public void testGetMessageDetails_generalDNSMessage_noActionOrStatus() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("DSNMessageNoActionOrStatus.txt");
        msg.setHeader("in-reply-to", "");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertNull(details.get(TxDetailType.DSN_ACTION.getType()));
        Assertions.assertNull(details.get(TxDetailType.DSN_STATUS.getType()));
    }

    @Test
    public void testGetMessageDetails_commonMessage_timelyAndReliable() throws Exception {
        MimeMessage msg = TestUtils.readMimeMessageFromFile("MessageWithAttachment.txt");
        msg.setHeader("Disposition-Notification-Options", "X-DIRECT-FINAL-DESTINATION-DELIVERY=optional,true");
        DefaultTxDetailParser parser = new DefaultTxDetailParser();
        Map details = parser.getMessageDetails(msg);
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"message-id"), (Object)((TxDetail)details.get(TxDetailType.MSG_ID.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"from").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.FROM.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"to").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.RECIPIENTS.getType())).getDetailValue());
        Assertions.assertEquals((Object)MailStandard.getHeader((MimeMessage)msg, (String)"subject").toLowerCase(Locale.getDefault()), (Object)((TxDetail)details.get(TxDetailType.SUBJECT.getType())).getDetailValue());
    }
}

