/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.model;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;

public class TxDetailTest {
    @Test
    public void testConstruct_defaultConstructor() {
        TxDetail detail = new TxDetail();
        Assertions.assertEquals((Object)TxDetailType.UNKNOWN.getType(), (Object)detail.getDetailName());
        Assertions.assertTrue((boolean)detail.getDetailValue().isEmpty());
    }

    @Test
    public void testConstruct_paramaterizedTypeConstructor() {
        TxDetail detail = new TxDetail(TxDetailType.FROM, "");
        Assertions.assertEquals((Object)TxDetailType.FROM.getType(), (Object)detail.getDetailName());
        Assertions.assertTrue((boolean)detail.getDetailValue().isEmpty());
        detail = new TxDetail(TxDetailType.FROM, "value");
        Assertions.assertEquals((Object)TxDetailType.FROM.getType(), (Object)detail.getDetailName());
        Assertions.assertEquals((Object)"value", (Object)detail.getDetailValue());
    }

    @Test
    public void testConstruct_paramaterizedStringConstructor() {
        TxDetail detail = new TxDetail(TxDetailType.FROM.getType(), "");
        Assertions.assertEquals((Object)TxDetailType.FROM.getType(), (Object)detail.getDetailName());
        Assertions.assertTrue((boolean)detail.getDetailValue().isEmpty());
        detail = new TxDetail(TxDetailType.FROM, "value");
        Assertions.assertEquals((Object)TxDetailType.FROM.getType(), (Object)detail.getDetailName());
        Assertions.assertEquals((Object)"value", (Object)detail.getDetailValue());
    }

    @Test
    public void testConstruct_paramaterizedStringConstructor_nullType() {
        boolean exceptionOccured = false;
        try {
            new TxDetail((String)null, "");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_paramaterizedStringConstructor_emptyType() {
        boolean exceptionOccured = false;
        try {
            new TxDetail("", "");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_paramaterizedStringConstructor_nullValue() {
        boolean exceptionOccured = false;
        try {
            new TxDetail(TxDetailType.FROM.getType(), null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_setGetName() {
        TxDetail detail = new TxDetail(TxDetailType.FROM.getType(), "");
        detail.setDetailName(TxDetailType.DISPOSITION.getType());
        Assertions.assertEquals((Object)TxDetailType.DISPOSITION.getType(), (Object)detail.getDetailName());
    }

    @Test
    public void testConstruct_setName_nullName() {
        TxDetail detail = new TxDetail();
        boolean exceptionOccured = false;
        try {
            detail.setDetailName(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_setName_emptyName() {
        TxDetail detail = new TxDetail();
        boolean exceptionOccured = false;
        try {
            detail.setDetailName(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_setGetValue() {
        TxDetail detail = new TxDetail(TxDetailType.FROM.getType(), "");
        detail.setDetailValue("value");
        Assertions.assertEquals((Object)"value", (Object)detail.getDetailValue());
    }

    @Test
    public void testConstruct_setValue_nullValue() {
        TxDetail detail = new TxDetail();
        boolean exceptionOccured = false;
        try {
            detail.setDetailValue(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

