/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.tx.model;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.common.tx.model.Tx;
import org.nhindirect.common.tx.model.TxDetail;
import org.nhindirect.common.tx.model.TxDetailType;
import org.nhindirect.common.tx.model.TxMessageType;

public class TxTest {
    @Test
    public void testConstruct_defaultConstructor() {
        Tx tx = new Tx();
        Assertions.assertEquals((Object)TxMessageType.UNKNOWN, (Object)tx.getMsgType());
        Assertions.assertNotNull((Object)tx.getDetails());
        Assertions.assertEquals((int)0, (int)tx.getDetails().values().size());
    }

    @Test
    public void testConstruct_parameterizedConstructor() {
        Tx tx = new Tx(TxMessageType.DSN, new HashMap());
        Assertions.assertEquals((Object)TxMessageType.DSN, (Object)tx.getMsgType());
        Assertions.assertNotNull((Object)tx.getDetails());
        Assertions.assertEquals((int)0, (int)tx.getDetails().values().size());
    }

    @Test
    public void testConstruct_parameterizedConstructor_nullDetails() {
        boolean exceptionOccured = false;
        try {
            new Tx(TxMessageType.DSN, null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_parameterizedConstructor_nullType() {
        boolean exceptionOccured = false;
        try {
            new Tx(null, new HashMap());
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_setGetMessageType() {
        Tx tx = new Tx();
        Assertions.assertEquals((Object)TxMessageType.UNKNOWN, (Object)tx.getMsgType());
        tx.setMsgType(TxMessageType.IMF);
        Assertions.assertEquals((Object)TxMessageType.IMF, (Object)tx.getMsgType());
    }

    @Test
    public void testConstruct_setType_nullType() {
        Tx tx = new Tx();
        boolean exceptionOccured = false;
        try {
            tx.setMsgType(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_setGetDetails() {
        Tx tx = new Tx();
        Assertions.assertEquals((Object)TxMessageType.UNKNOWN, (Object)tx.getMsgType());
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        tx.setDetails(details);
        Assertions.assertEquals((int)1, (int)tx.getDetails().size());
        Assertions.assertEquals(details, (Object)tx.getDetails());
    }

    @Test
    public void testConstruct_setDetails_nullDetails() {
        Tx tx = new Tx();
        boolean exceptionOccured = false;
        try {
            tx.setDetails(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testConstruct_getDetailByType() {
        Tx tx = new Tx();
        Assertions.assertEquals((Object)TxMessageType.UNKNOWN, (Object)tx.getMsgType());
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        tx.setDetails(details);
        Assertions.assertNotNull((Object)tx.getDetail(TxDetailType.FROM.getType()));
        Assertions.assertNull((Object)tx.getDetail(TxDetailType.RECIPIENTS.getType()));
        Assertions.assertNull((Object)tx.getDetail((String)null));
        Assertions.assertNull((Object)tx.getDetail(""));
    }

    @Test
    public void testConstruct_getDetailByEnum() {
        Tx tx = new Tx();
        Assertions.assertEquals((Object)TxMessageType.UNKNOWN, (Object)tx.getMsgType());
        HashMap<String, TxDetail> details = new HashMap<String, TxDetail>();
        details.put(TxDetailType.FROM.getType(), new TxDetail(TxDetailType.FROM, "me@test.com"));
        tx.setDetails(details);
        Assertions.assertNotNull((Object)tx.getDetail(TxDetailType.FROM));
        Assertions.assertNull((Object)tx.getDetail(TxDetailType.RECIPIENTS));
        Assertions.assertNull((Object)tx.getDetail((TxDetailType)null));
    }
}

