/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.monitor.boot;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@EnableWebSecurity
@Configuration
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final String BCRYPT_PREFIX = "{bcrypt}";
    @Value(value="${spring.security.user.name}")
    protected String username;
    @Value(value="${spring.security.user.password}")
    protected String password;

    protected void configure(HttpSecurity httpSecurity) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)httpSecurity.authorizeRequests().antMatchers(new String[]{"/**"})).authenticated().and()).httpBasic();
        httpSecurity.csrf().disable();
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        this.password = this.password.startsWith(BCRYPT_PREFIX) ? this.password.substring(BCRYPT_PREFIX.length()) : this.passwordEncoder().encode((CharSequence)this.password);
        ((InMemoryUserDetailsManagerConfigurer)auth.inMemoryAuthentication().passwordEncoder(this.passwordEncoder())).withUser(this.username).password(this.password).roles(new String[]{"USER"});
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

