/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy;

import java.util.HashMap;
import java.util.Map;
import org.nhindirect.policy.PolicyOperatorParamsType;
import org.nhindirect.policy.impl.BinaryBooleanPolicyOperatorExecutor;
import org.nhindirect.policy.impl.BinaryCollectionPolicyOperatorExecutor;
import org.nhindirect.policy.impl.BinaryIntegerPolicyOperatorExecutor;
import org.nhindirect.policy.impl.UnaryBooleanPolicyOperatorExecutor;
import org.nhindirect.policy.impl.UnaryIntegerPolicyOperatorExecutor;

public final class PolicyOperator
extends Enum<PolicyOperator> {
    public static final /* enum */ PolicyOperator EQUALS;
    public static final /* enum */ PolicyOperator NOT_EQUALS;
    public static final /* enum */ PolicyOperator GREATER;
    public static final /* enum */ PolicyOperator LESS;
    public static final /* enum */ PolicyOperator REG_EX;
    public static final /* enum */ PolicyOperator CONTAINS;
    public static final /* enum */ PolicyOperator NOT_CONTAINS;
    public static final /* enum */ PolicyOperator CONTAINS_REG_EX;
    public static final /* enum */ PolicyOperator SIZE;
    public static final /* enum */ PolicyOperator EMPTY;
    public static final /* enum */ PolicyOperator NOT_EMPTY;
    public static final /* enum */ PolicyOperator INTERSECTION;
    public static final /* enum */ PolicyOperator LOGICAL_OR;
    public static final /* enum */ PolicyOperator LOGICAL_AND;
    public static final /* enum */ PolicyOperator LOGICAL_NOT;
    public static final /* enum */ PolicyOperator BITWISE_AND;
    public static final /* enum */ PolicyOperator BITWISE_OR;
    public static final /* enum */ PolicyOperator URI_VALIDATE;
    protected final String operatorToken;
    protected final String operatorText;
    protected final Class<?> executorClass;
    protected final PolicyOperatorParamsType paramsType;
    protected static final Map<String, PolicyOperator> tokenOperatorMap;
    private static final /* synthetic */ PolicyOperator[] $VALUES;

    public static PolicyOperator[] values() {
        return (PolicyOperator[])$VALUES.clone();
    }

    public static PolicyOperator valueOf(String name) {
        return Enum.valueOf(PolicyOperator.class, name);
    }

    private PolicyOperator(String operatorToken, String operatorText, Class<?> executorClass, PolicyOperatorParamsType paramsType) {
        this.operatorToken = operatorToken;
        this.operatorText = operatorText;
        this.executorClass = executorClass;
        this.paramsType = paramsType;
    }

    public String getOperatorToken() {
        return this.operatorToken;
    }

    public String getOperatorText() {
        return this.operatorText;
    }

    public Class<?> getExecutorClass() {
        return this.executorClass;
    }

    public PolicyOperatorParamsType getParamsType() {
        return this.paramsType;
    }

    public static PolicyOperator fromToken(String token) {
        return tokenOperatorMap.get(token);
    }

    static {
        PolicyOperator[] operators;
        EQUALS = new PolicyOperator("=", "equals", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        NOT_EQUALS = new PolicyOperator("!=", "not equals", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        GREATER = new PolicyOperator(">", "greater than", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        LESS = new PolicyOperator("<", "less than", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        REG_EX = new PolicyOperator("$", "matches", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        CONTAINS = new PolicyOperator("{?}", "contains", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        NOT_CONTAINS = new PolicyOperator("{?}!", "not contains", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        CONTAINS_REG_EX = new PolicyOperator("{}$", "contains match", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        SIZE = new PolicyOperator("^", "size", UnaryIntegerPolicyOperatorExecutor.class, PolicyOperatorParamsType.UNARY);
        EMPTY = new PolicyOperator("{}", "empty", UnaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.UNARY);
        NOT_EMPTY = new PolicyOperator("{}!", "not empty", UnaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.UNARY);
        INTERSECTION = new PolicyOperator("{}&", "intersection", BinaryCollectionPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        LOGICAL_OR = new PolicyOperator("||", "or", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        LOGICAL_AND = new PolicyOperator("&&", "and", BinaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        LOGICAL_NOT = new PolicyOperator("!", "not", UnaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.UNARY);
        BITWISE_AND = new PolicyOperator("&", "bitand", BinaryIntegerPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        BITWISE_OR = new PolicyOperator("|", "bitor", BinaryIntegerPolicyOperatorExecutor.class, PolicyOperatorParamsType.BINARY);
        URI_VALIDATE = new PolicyOperator("@@", "uri validate", UnaryBooleanPolicyOperatorExecutor.class, PolicyOperatorParamsType.UNARY);
        $VALUES = new PolicyOperator[]{EQUALS, NOT_EQUALS, GREATER, LESS, REG_EX, CONTAINS, NOT_CONTAINS, CONTAINS_REG_EX, SIZE, EMPTY, NOT_EMPTY, INTERSECTION, LOGICAL_OR, LOGICAL_AND, LOGICAL_NOT, BITWISE_AND, BITWISE_OR, URI_VALIDATE};
        tokenOperatorMap = new HashMap<String, PolicyOperator>();
        for (PolicyOperator operator : operators = (PolicyOperator[])PolicyOperator[].class.cast(PolicyOperator.class.getEnumConstants())) {
            tokenOperatorMap.put(operator.getOperatorToken(), operator);
        }
    }
}

