/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;

public class AuthorityInfoAccessOCSPLocExtentionField
extends AbstractExtensionField<Collection<String>>
implements ExtensionField<Collection<String>> {
    static final long serialVersionUID = 3202084104837274531L;

    public AuthorityInfoAccessOCSPLocExtentionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        DERObject exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            List coll = Collections.emptyList();
            this.policyValue = PolicyValueFactory.getInstance(coll);
            return;
        }
        AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)exValue);
        ArrayList<String> retVal = new ArrayList<String>();
        for (AccessDescription accessDescription : aia.getAccessDescriptions()) {
            if (!accessDescription.getAccessMethod().equals((Object)AccessDescription.id_ad_ocsp)) continue;
            retVal.add(accessDescription.getAccessLocation().getName().toString());
        }
        if (retVal.isEmpty() && this.isRequired()) {
            throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
        }
        this.policyValue = PolicyValueFactory.getInstance(retVal);
    }

    @Override
    public ExtensionIdentifier getExtentionIdentifier() {
        return ExtensionIdentifier.AUTHORITY_INFO_ACCESS;
    }
}

