/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;

public class BasicContraintsExtensionField
extends AbstractExtensionField<Boolean>
implements ExtensionField<Boolean> {
    static final long serialVersionUID = -2492905720544301651L;

    public BasicContraintsExtensionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        DERObject exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            this.policyValue = PolicyValueFactory.getInstance(false);
            return;
        }
        BasicConstraints constraints = BasicConstraints.getInstance((Object)exValue);
        this.policyValue = PolicyValueFactory.getInstance(constraints.isCA());
    }

    @Override
    public ExtensionIdentifier getExtentionIdentifier() {
        return ExtensionIdentifier.BASIC_CONSTRAINTS;
    }
}

