/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;

public class ExtendedKeyUsageExtensionField
extends AbstractExtensionField<Collection<String>>
implements ExtensionField<Collection<String>> {
    static final long serialVersionUID = -2492905720544301651L;

    public ExtendedKeyUsageExtensionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        DERObject exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            List emptyList = Collections.emptyList();
            this.policyValue = PolicyValueFactory.getInstance(emptyList);
            return;
        }
        ExtendedKeyUsage usages = ExtendedKeyUsage.getInstance((Object)exValue);
        Vector purposeList = usages.getUsages();
        ArrayList<String> usageList = new ArrayList<String>();
        for (DERObjectIdentifier purpose : purposeList) {
            usageList.add(purpose.getId());
        }
        this.policyValue = PolicyValueFactory.getInstance(usageList);
    }

    @Override
    public ExtensionIdentifier getExtentionIdentifier() {
        return ExtensionIdentifier.EXTENDED_KEY_USAGE;
    }
}

