/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nhindirect.policy.x509.AuthorityInfoAccessExtentionField;
import org.nhindirect.policy.x509.AuthorityInfoAccessOCSPLocExtentionField;
import org.nhindirect.policy.x509.AuthorityKeyIdentifierKeyIdExtensionField;
import org.nhindirect.policy.x509.BasicContraintsExtensionField;
import org.nhindirect.policy.x509.CRLDistributionPointNameExtentionField;
import org.nhindirect.policy.x509.CertificatePolicyCpsUriExtensionField;
import org.nhindirect.policy.x509.CertificatePolicyIndentifierExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.KeyUsageExtensionField;
import org.nhindirect.policy.x509.SubjectAltNameExtensionField;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;

public final class ExtensionIdentifier
extends Enum<ExtensionIdentifier> {
    public static final /* enum */ ExtensionIdentifier KEY_USAGE;
    public static final /* enum */ ExtensionIdentifier SUBJECT_ALT_NAME;
    public static final /* enum */ ExtensionIdentifier SUBJECT_DIRECTORY_ATTRIBUTES;
    public static final /* enum */ ExtensionIdentifier SUBJECT_KEY_IDENTIFIER;
    public static final /* enum */ ExtensionIdentifier ISSUER_ALT_NAME;
    public static final /* enum */ ExtensionIdentifier AUTHORITY_KEY_IDENTIFIER;
    public static final /* enum */ ExtensionIdentifier CERTIFICATE_POLICIES;
    public static final /* enum */ ExtensionIdentifier POLICY_MAPPINGS;
    public static final /* enum */ ExtensionIdentifier BASIC_CONSTRAINTS;
    public static final /* enum */ ExtensionIdentifier NAME_CONSTRAINTS;
    public static final /* enum */ ExtensionIdentifier POLICY_CONSTRAINTS;
    public static final /* enum */ ExtensionIdentifier EXTENDED_KEY_USAGE;
    public static final /* enum */ ExtensionIdentifier CRL_DISTRIBUTION_POINTS;
    public static final /* enum */ ExtensionIdentifier INHIBIT_ANY_POLICY;
    public static final /* enum */ ExtensionIdentifier FRESHEST_CRL;
    public static final /* enum */ ExtensionIdentifier AUTHORITY_INFO_ACCESS;
    public static final /* enum */ ExtensionIdentifier SUBJECT_INFO_ACCESS;
    protected final String id;
    protected final String rfcName;
    protected final String display;
    protected final Collection<AttributeReferenceClass> subAttributes;
    protected final Class<? extends ExtensionField<?>> referenceClass;
    protected static final Map<String, ExtensionIdentifier> tokenFieldMap;
    private static final /* synthetic */ ExtensionIdentifier[] $VALUES;

    public static ExtensionIdentifier[] values() {
        return (ExtensionIdentifier[])$VALUES.clone();
    }

    public static ExtensionIdentifier valueOf(String name) {
        return Enum.valueOf(ExtensionIdentifier.class, name);
    }

    private ExtensionIdentifier(String id, String rfcName, String display, List<AttributeReferenceClass> subAttributes) {
        this.id = id;
        this.rfcName = rfcName;
        this.display = display;
        this.subAttributes = new ArrayList<AttributeReferenceClass>(subAttributes);
        this.referenceClass = null;
        if (this.subAttributes.size() > 0) {
            ArrayList<AttributeReferenceClass> addAttributes = new ArrayList<AttributeReferenceClass>();
            for (AttributeReferenceClass addRefClass : this.subAttributes) {
                addAttributes.add(new AttributeReferenceClass(addRefClass.getAttribute() + "+", addRefClass.getReferenceClass()));
            }
            this.subAttributes.addAll(addAttributes);
        }
    }

    private ExtensionIdentifier(String id, String rfcName, String display, Class<? extends ExtensionField<?>> referenceClass) {
        this.id = id;
        this.rfcName = rfcName;
        this.display = display;
        this.subAttributes = null;
        this.referenceClass = referenceClass;
    }

    public String getId() {
        return this.id;
    }

    public String getRfcName() {
        return this.rfcName;
    }

    public String getDisplay() {
        return this.display;
    }

    public Collection<String> getFieldTokens() {
        if (this.subAttributes == null || this.subAttributes.isEmpty()) {
            return Arrays.asList("X509.TBS.EXTENSION." + this.rfcName, "X509.TBS.EXTENSION." + this.rfcName + "+");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeReferenceClass attrRef : this.subAttributes) {
            names.add("X509.TBS.EXTENSION." + this.rfcName + "." + attrRef.getAttribute());
        }
        return names;
    }

    public Class<? extends ExtensionField<?>> getReferenceClass(String tokenName) {
        Class<? extends ExtensionField<?>> retVal = null;
        if (this.referenceClass != null) {
            return this.referenceClass;
        }
        int idx = tokenName.lastIndexOf(".");
        if (idx >= 0) {
            String name = tokenName.substring(idx + 1);
            for (AttributeReferenceClass attrRef : this.subAttributes) {
                if (!name.equals(attrRef.getAttribute())) continue;
                retVal = attrRef.getReferenceClass();
                break;
            }
        }
        return retVal;
    }

    public static ExtensionIdentifier fromToken(String token) {
        return tokenFieldMap.get(token);
    }

    public String toString() {
        return this.rfcName;
    }

    static {
        ExtensionIdentifier[] extensions;
        KEY_USAGE = new ExtensionIdentifier("2.5.29.15", "KeyUsage", "Key Usage", KeyUsageExtensionField.class);
        SUBJECT_ALT_NAME = new ExtensionIdentifier("2.5.29.17", "SubjectAltName", "Subject Alternative Name", SubjectAltNameExtensionField.class);
        SUBJECT_DIRECTORY_ATTRIBUTES = new ExtensionIdentifier("2.5.29.9", "SubjectDirectoryAttributes", "Subject Key Attributes", new ArrayList<AttributeReferenceClass>());
        SUBJECT_KEY_IDENTIFIER = new ExtensionIdentifier("2.5.29.14", "SubjectKeyIdentifier", "Subject Key Identifier", SubjectKeyIdentifierExtensionField.class);
        ISSUER_ALT_NAME = new ExtensionIdentifier("2.5.29.18", "IssuerAltName", "Issuer Alternative Name", new ArrayList<AttributeReferenceClass>());
        AUTHORITY_KEY_IDENTIFIER = new ExtensionIdentifier("2.5.29.35", "AuthorityKeyIdentifier", "Authority Key Identifier", Arrays.asList(new AttributeReferenceClass("KeyId", AuthorityKeyIdentifierKeyIdExtensionField.class), new AttributeReferenceClass("CertIssuers", null), new AttributeReferenceClass("SerialNumber", null)));
        CERTIFICATE_POLICIES = new ExtensionIdentifier("2.5.29.32", "CertificatePolicies", "Certificate Policies", Arrays.asList(new AttributeReferenceClass("PolicyOIDs", CertificatePolicyIndentifierExtensionField.class), new AttributeReferenceClass("CPSUrls", CertificatePolicyCpsUriExtensionField.class)));
        POLICY_MAPPINGS = new ExtensionIdentifier("2.5.29.33", "PolicyMappings", "Policy Mappings", new ArrayList<AttributeReferenceClass>());
        BASIC_CONSTRAINTS = new ExtensionIdentifier("2.5.29.19", "BasicConstraints", "Basic Constraints", Arrays.asList(new AttributeReferenceClass("CA", BasicContraintsExtensionField.class), new AttributeReferenceClass("MaxPathLength", null)));
        NAME_CONSTRAINTS = new ExtensionIdentifier("2.5.29.30", "NameConstraints", "Name Constraints", new ArrayList<AttributeReferenceClass>());
        POLICY_CONSTRAINTS = new ExtensionIdentifier("2.5.29.36", "PolicyConstraints", "Policy Constraints", new ArrayList<AttributeReferenceClass>());
        EXTENDED_KEY_USAGE = new ExtensionIdentifier("2.5.29.37", "ExtKeyUsageSyntax", "Extended Key Usage", ExtendedKeyUsageExtensionField.class);
        CRL_DISTRIBUTION_POINTS = new ExtensionIdentifier("2.5.29.31", "CRLDistributionPoints", "CRL Distribution Points", Arrays.asList(new AttributeReferenceClass("FullName", CRLDistributionPointNameExtentionField.class), new AttributeReferenceClass("RelativeToIssuer", null), new AttributeReferenceClass("Reasons", null), new AttributeReferenceClass("CRLIssuer", null)));
        INHIBIT_ANY_POLICY = new ExtensionIdentifier("2.5.29.54", "InhibitAnyPolicy", "Inhibit Any Policy", new ArrayList<AttributeReferenceClass>());
        FRESHEST_CRL = new ExtensionIdentifier("2.5.29.46", "FreshestCRL", "Freshest CRL", Arrays.asList(new AttributeReferenceClass("FullName", null), new AttributeReferenceClass("RelativeToIssuer", null), new AttributeReferenceClass("Reasons", null), new AttributeReferenceClass("CRLIssuer", null)));
        AUTHORITY_INFO_ACCESS = new ExtensionIdentifier("1.3.6.1.5.5.7.1.1", "AuthorityInfoAccessSyntax", "AuthorityInfoAccessSyntax", Arrays.asList(new AttributeReferenceClass("Url", AuthorityInfoAccessExtentionField.class), new AttributeReferenceClass("AccessMethod", null), new AttributeReferenceClass("OCSPLocation", AuthorityInfoAccessOCSPLocExtentionField.class)));
        SUBJECT_INFO_ACCESS = new ExtensionIdentifier("1.3.6.1.5.5.7.1.11", "SubjectInfoAccessSyntax", "Subject Information Access", Arrays.asList(new AttributeReferenceClass("Url", null), new AttributeReferenceClass("AccessMethod", null), new AttributeReferenceClass("OCSPLocation", null)));
        $VALUES = new ExtensionIdentifier[]{KEY_USAGE, SUBJECT_ALT_NAME, SUBJECT_DIRECTORY_ATTRIBUTES, SUBJECT_KEY_IDENTIFIER, ISSUER_ALT_NAME, AUTHORITY_KEY_IDENTIFIER, CERTIFICATE_POLICIES, POLICY_MAPPINGS, BASIC_CONSTRAINTS, NAME_CONSTRAINTS, POLICY_CONSTRAINTS, EXTENDED_KEY_USAGE, CRL_DISTRIBUTION_POINTS, INHIBIT_ANY_POLICY, FRESHEST_CRL, AUTHORITY_INFO_ACCESS, SUBJECT_INFO_ACCESS};
        tokenFieldMap = new HashMap<String, ExtensionIdentifier>();
        for (ExtensionIdentifier extension : extensions = (ExtensionIdentifier[])ExtensionIdentifier[].class.cast(ExtensionIdentifier.class.getEnumConstants())) {
            for (String token : extension.getFieldTokens()) {
                tokenFieldMap.put(token, extension);
            }
        }
    }

    public static class AttributeReferenceClass {
        protected final String attribute;
        protected final Class<? extends ExtensionField<?>> referenceClass;

        public AttributeReferenceClass(String attribute, Class<? extends ExtensionField<?>> referenceClass) {
            this.attribute = attribute;
            this.referenceClass = referenceClass;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Class<? extends ExtensionField<?>> getReferenceClass() {
            return this.referenceClass;
        }
    }
}

