/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;
import org.nhindirect.policy.x509.AuthorityInfoAccessExtentionField;
import org.nhindirect.policy.x509.AuthorityInfoAccessOCSPLocExtentionField;
import org.nhindirect.policy.x509.AuthorityKeyIdentifierKeyIdExtensionField;
import org.nhindirect.policy.x509.BasicContraintsExtensionField;
import org.nhindirect.policy.x509.CRLDistributionPointNameExtentionField;
import org.nhindirect.policy.x509.CertificatePolicyCpsUriExtensionField;
import org.nhindirect.policy.x509.CertificatePolicyIndentifierExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.KeyUsageExtensionField;
import org.nhindirect.policy.x509.SubjectAltNameExtensionField;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;

public class SimpleTextV1LexiconPolicyParser_buildExtensionFieldTest {
    @Test
    public void testBuildExtensionField_keyUsage_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.KeyUsage"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof KeyUsageExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.KeyUsage+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof KeyUsageExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_subjectAltName_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectAltName"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAltNameExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectAltName+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAltNameExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_subjectDirectoryAttributes_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectDirectoryAttributes");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectDirectoryAttributes+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_subjectKeyIdentifier_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectKeyIdentifier"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectKeyIdentifierExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectKeyIdentifier+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectKeyIdentifierExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_issuierAltName_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.IssuerAltName");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.IssuerAltName+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_autorityKeyId_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.KeyId"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityKeyIdentifierKeyIdExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.KeyId+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityKeyIdentifierKeyIdExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.CertIssuers");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.CertIssuers+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.SerialNumber");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.SerialNumber+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_certificatePolicies_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.PolicyOIDs"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CertificatePolicyIndentifierExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.PolicyOIDs+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CertificatePolicyIndentifierExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.CPSUrls"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CertificatePolicyCpsUriExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.CPSUrls+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CertificatePolicyCpsUriExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_policyMappings_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyMappings");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyMappings+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_basicContraints_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.CA"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof BasicContraintsExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.CA+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof BasicContraintsExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.MaxPathLength");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.MaxPathLength+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_nameConstraints_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.NameConstraints");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.NameConstraints+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_policyConstraints_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyConstraints");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyConstraints+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_extendedKeyUsage_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.ExtKeyUsageSyntax"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof ExtendedKeyUsageExtensionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.ExtKeyUsageSyntax+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof ExtendedKeyUsageExtensionField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_crlDispPoints_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.FullName"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CRLDistributionPointNameExtentionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.FullName+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof CRLDistributionPointNameExtentionField));
        Assert.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.RelativeToIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.RelativeToIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.Reasons");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.Reasons+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.CRLIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.CRLIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_inhibitAnyPolicy_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.InhibitAnyPolicy");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.InhibitAnyPolicy+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_freshestCRL_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.FullName");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.FullName+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.RelativeToIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.RelativeToIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.Reasons");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.Reasons+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.CRLIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.CRLIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_auhtorityInformationAccess_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.Url"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityInfoAccessExtentionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.Url+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityInfoAccessExtentionField));
        Assert.assertTrue((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.OCSPLocation"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityInfoAccessOCSPLocExtentionField));
        Assert.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.OCSPLocation+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof AuthorityInfoAccessOCSPLocExtentionField));
        Assert.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.AccessMethod");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.AccessMethod+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_auhtorityInformationAccess_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.Url");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.Url+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.AccessMethod");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.AccessMethod+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.OCSPLocation");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.OCSPLocation+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_unknownField_assertNull() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.Bogus"));
        Assert.assertNull((Object)field);
    }
}

