/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.SerialNumberAttributeField;
import org.nhindirect.policy.x509.SubjectAttributeField;
import org.nhindirect.policy.x509.SubjectPublicKeyAlgorithmField;
import org.nhindirect.policy.x509.SubjectPublicKeySizeField;
import org.nhindirect.policy.x509.TBSField;

public class SimpleTextV1LexiconPolicyParser_buildTBSFieldTest {
    @Test
    public void testBuildTBSField_version_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Version"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_serialNumber_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SerialNumber"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SerialNumberAttributeField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_signature_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Signature"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Signature+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_issuer_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.CN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.CN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.C"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.C+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.O"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.O+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.OU"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.OU+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.ST"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.ST+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.L"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.L+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.E"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.E+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DC"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DC+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DNQUALIFIER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DNQUALIFIER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SERIALNUMBER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SERIALNUMBER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.TITLE"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.TITLE+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GIVENNAME"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GIVENNAME+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.INITIALS"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.INITIALS+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.PSEUDONYM"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.PSEUDONYM+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GERNERAL_QUALIFIER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GERNERAL_QUALIFIER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_validity_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidFrom"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidFrom+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidTo"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidTo+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subject_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.CN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.CN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.C"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.C+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.O"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.O+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.OU"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.OU+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.ST"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.ST+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.L"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.L+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.E"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.E+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DC"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DC+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DNQUALIFIER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DNQUALIFIER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SERIALNUMBER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SERIALNUMBER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.TITLE"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.TITLE+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GIVENNAME"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GIVENNAME+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.INITIALS"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.INITIALS+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.PSEUDONYM"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.PSEUDONYM+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GERNERAL_QUALIFIER"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GERNERAL_QUALIFIER+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DN"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DN+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assert.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_issuerUniqueId_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.IssuerUniqueID"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.IssuerUniqueID+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subjectUniqueId_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectUniqueID"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectUniqueID+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subjectPublicKeyInfo_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Algorithm"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectPublicKeyAlgorithmField));
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Algorithm+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectPublicKeyAlgorithmField));
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Size"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectPublicKeySizeField));
        Assert.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Size+"));
        Assert.assertNotNull((Object)field);
        Assert.assertTrue((boolean)(field instanceof SubjectPublicKeySizeField));
        Assert.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_unknownField_assertNull() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Bugos"));
        Assert.assertNull((Object)field);
    }
}

