/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;

public class SimpleTextV1LexiconPolicyParser_parseToTokensTest {
    @Test
    public void testParse_simpleExpression_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/simpleLexiconSamp1.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assert.assertEquals((long)11L, (long)tokens.size());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_logicalAndOperator_validateSingleTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/logicalAndOperator.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assert.assertEquals((long)1L, (long)tokens.size());
        Assert.assertEquals((Object)"&&", (Object)((SimpleTextV1LexiconPolicyParser.TokenTypeAssociation)tokens.iterator().next()).getToken());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_CertificateStruct_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/lexiconWithCertificateStruct.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assert.assertEquals((long)3L, (long)tokens.size());
        Assert.assertEquals((Object)SimpleTextV1LexiconPolicyParser.TokenType.CERTIFICATE_REFERENCE_EXPRESSION, (Object)((SimpleTextV1LexiconPolicyParser.TokenTypeAssociation)tokens.iterator().next()).getType());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_literalWithSpaces_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/literalWithSpaces.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assert.assertEquals((long)3L, (long)tokens.size());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_requiredCertField_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"X509.TBS.EXTENSION.SubjectKeyIdentifier+ = 1.3.2.3");
        Vector tokens = parser.parseToTokens(stream);
        Assert.assertEquals((long)3L, (long)tokens.size());
        stream.close();
    }
}

