/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.impl.machine.StackMachine;
import org.nhindirect.policy.impl.machine.StackMachineEntry;
import org.nhindirect.policy.mock.SpringBaseTest;

public class StackMachine_evaluateTest
extends SpringBaseTest {
    @Test
    public void testEvaluate_singleBooleanEntry_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_singleBooleanEntry_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_equalsSameStringValues_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_equalsDifferentStringValues_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"22345")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_notEqualsSameStringValues_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.NOT_EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_notEqualsDifferentStringValues_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"22345")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.NOT_EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_equalsDifferentTypeValues_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)12345)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_notEqualsDifferentTypeValues_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)12345)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.NOT_EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_regExStringMatches_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"bbbbb")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"a|b*")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.REG_EX));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_regExStringNotMatch_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"cccc")));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"a|b")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.REG_EX));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_greater_topOfStackIsGreater_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.GREATER));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_greater_bottomOfStockIsGreater_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.GREATER));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_less_topOfStackIsLess_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LESS));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_less_bottomOfStockIsLess_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LESS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalOrBothTrue_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_OR));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalOrOneTrue_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_OR));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
        stuffToProcess = new Vector();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_OR));
        stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalOrNeitherTrue_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_OR));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalAndBothTrue_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_AND));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalAndOneTrue_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_AND));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
        stuffToProcess = new Vector();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_AND));
        stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalAndBothFalse_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_AND));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseOrBitSetOnBoth_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_OR));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseOrBitSetOnOne_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_OR));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
        stuffToProcess = new Vector();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_OR));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseOrBitSetOnNeither_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_OR));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseAndBitSetOnBoth_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_AND));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseAndBitSetOnOne_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_AND));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
        stuffToProcess = new Vector();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_AND));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_bitwiseAndBitSetOnNeither_assertEquals() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.BITWISE_AND));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalNotFalseValue_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_NOT));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_logicalNotTrueValue_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_NOT));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_sizeCollection_empty_assertSize0() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance(Collections.emptyList())));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.SIZE));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)0)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_sizeCollection_singleEntry_assertSize1() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance(Arrays.asList("Hello"))));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.SIZE));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)1)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.EQUALS));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_uriValidate_validUri_assertTrue() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"http://localhost:8080/cps")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.URI_VALIDATE));
        StackMachine stMachine = new StackMachine();
        Assert.assertTrue((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_uriValidate_notFoundUri_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"http://www.google.com/333333")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.URI_VALIDATE));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_uriValidate_noHostURI_assertFalse() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"http://bogus.unit.test.ccc")));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.URI_VALIDATE));
        StackMachine stMachine = new StackMachine();
        Assert.assertFalse((boolean)stMachine.evaluate(stuffToProcess));
    }

    @Test
    public void testEvaluate_notEnoughParamsForBinaryOperation_assertException() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)true)));
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_OR));
        boolean exceptionOccured = false;
        StackMachine stMachine = new StackMachine();
        try {
            stMachine.evaluate(stuffToProcess);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testEvaluate_notEnoughParamsForUnaryOperation_assertException() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyOperator.LOGICAL_NOT));
        boolean exceptionOccured = false;
        StackMachine stMachine = new StackMachine();
        try {
            stMachine.evaluate(stuffToProcess);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testEvaluate_finalEmptyStack_assertException() throws Exception {
        Vector stuffToProcess = new Vector();
        boolean exceptionOccured = false;
        StackMachine stMachine = new StackMachine();
        try {
            stMachine.evaluate(stuffToProcess);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testEvaluate_finalStackGreaterThanSingleEntry_assertException() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)false)));
        boolean exceptionOccured = false;
        StackMachine stMachine = new StackMachine();
        try {
            stMachine.evaluate(stuffToProcess);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testEvaluate_finalNonBoolEntry_assertException() throws Exception {
        Vector<StackMachineEntry> stuffToProcess = new Vector<StackMachineEntry>();
        stuffToProcess.add(new StackMachineEntry(PolicyValueFactory.getInstance((Object)"12345")));
        boolean exceptionOccured = false;
        StackMachine stMachine = new StackMachine();
        try {
            stMachine.evaluate(stuffToProcess);
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

