/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.AuthorityInfoAccessExtentionField;
import org.nhindirect.policy.x509.AuthorityInfoAccessMethodIdentifier;

public class AuthorityInfoAccessExtentionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_aiaDoesNotExist_notRequired_assertValueEmpty() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        AuthorityInfoAccessExtentionField field = new AuthorityInfoAccessExtentionField(false);
        field.injectReferenceValue(cert);
        Assert.assertTrue((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
    }

    @Test
    public void testInjectRefereneValue_aiaDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        AuthorityInfoAccessExtentionField field = new AuthorityInfoAccessExtentionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_aiaExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirectProviderCA.der");
        AuthorityInfoAccessExtentionField field = new AuthorityInfoAccessExtentionField(false);
        field.injectReferenceValue(cert);
        Collection usages = (Collection)field.getPolicyValue().getPolicyValue();
        Assert.assertFalse((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
        Assert.assertTrue((boolean)usages.contains(AuthorityInfoAccessMethodIdentifier.OCSP.getName() + ":http://ca.cerner.com/OCSP"));
        Assert.assertTrue((boolean)usages.contains(AuthorityInfoAccessMethodIdentifier.CA_ISSUERS.getName() + ":http://ca.cerner.com/public/root.der"));
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        AuthorityInfoAccessExtentionField field = new AuthorityInfoAccessExtentionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

