/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.BasicContraintsExtensionField;

public class BasicContraintsExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectReferenceValue_basicContraintNotExists_notRequired_assertFalse() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("SESTestAccount-Signiture.der");
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertFalse((boolean)((Boolean)field.getPolicyValue().getPolicyValue()));
    }

    @Test
    public void testInjectReferenceValue_basicContraintNotExists_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("SESTestAccount-Signiture.der");
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectReferenceValue_basicContraintExists_assertFalse() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("cernerdemos.der");
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertFalse((boolean)((Boolean)field.getPolicyValue().getPolicyValue()));
    }

    @Test
    public void testInjectReferenceValue_basicContraintExists_assertTrue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("msanchor.der");
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertTrue((boolean)((Boolean)field.getPolicyValue().getPolicyValue()));
    }

    @Test
    public void testInjectReferenceValue_noInjection_getPolicyValue_assertException() throws Exception {
        BasicContraintsExtensionField field = new BasicContraintsExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

