/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.CertificatePolicyCpsUriExtensionField;

public class CertificatePolicyCpsUriExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_policyQualUriDoesNotExist_notRequired_assertValueEmpty() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertTrue((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
    }

    @Test
    public void testInjectRefereneValue_policyQualUriNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_policyQualUriExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirectProviderCA.der");
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(false);
        field.injectReferenceValue(cert);
        Collection pols = (Collection)field.getPolicyValue().getPolicyValue();
        Assert.assertTrue((boolean)pols.contains("http://www.cerner.com/CPS"));
    }

    @Test
    public void testInjectRefereneValue_policyQualUriExistsAndRequired_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirectProviderCA.der");
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(true);
        field.injectReferenceValue(cert);
        Collection pols = (Collection)field.getPolicyValue().getPolicyValue();
        Assert.assertTrue((boolean)pols.contains("http://www.cerner.com/CPS"));
    }

    @Test
    public void testInjectRefereneValue_mixedCPS_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("policyMixedQualifier.der");
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(true);
        field.injectReferenceValue(cert);
        Collection pols = (Collection)field.getPolicyValue().getPolicyValue();
        Assert.assertEquals((long)2L, (long)pols.size());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        CertificatePolicyCpsUriExtensionField field = new CertificatePolicyCpsUriExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

