/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.CertificatePolicyIndentifierExtensionField;

public class CertificatePolicyIndentifierExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_policyDoesNotExist_notRequired_assertValueEmpty() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CertificatePolicyIndentifierExtensionField field = new CertificatePolicyIndentifierExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertTrue((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
    }

    @Test
    public void testInjectRefereneValue_policyDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        CertificatePolicyIndentifierExtensionField field = new CertificatePolicyIndentifierExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_policyExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirectProviderCA.der");
        CertificatePolicyIndentifierExtensionField field = new CertificatePolicyIndentifierExtensionField(false);
        field.injectReferenceValue(cert);
        Collection usages = (Collection)field.getPolicyValue().getPolicyValue();
        Assert.assertFalse((boolean)((Collection)field.getPolicyValue().getPolicyValue()).isEmpty());
        Assert.assertTrue((boolean)usages.contains("2.16.840.1.113883.3.1313.0.1"));
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        CertificatePolicyIndentifierExtensionField field = new CertificatePolicyIndentifierExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

