/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.KeyUsageExtensionField;

public class KeyUsageExtensionField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_keyUsageDoesNotExist_notRequired_assertValue0() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        KeyUsageExtensionField field = new KeyUsageExtensionField(false);
        field.injectReferenceValue(cert);
        Assert.assertEquals((long)0L, (long)((Integer)field.getPolicyValue().getPolicyValue()).intValue());
    }

    @Test
    public void testInjectRefereneValue_keyUsageDoesNotExist_required_assertException() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        KeyUsageExtensionField field = new KeyUsageExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.injectReferenceValue(cert);
        }
        catch (PolicyRequiredException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testInjectRefereneValue_keyUsageExists_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        KeyUsageExtensionField field = new KeyUsageExtensionField(false);
        field.injectReferenceValue(cert);
        int value = (Integer)field.getPolicyValue().getPolicyValue();
        Assert.assertTrue(((0x20 & value) != 0 ? 1 : 0) != 0);
        Assert.assertTrue(((0x40 & value) != 0 ? 1 : 0) != 0);
        Assert.assertTrue(((0x80 & value) != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        KeyUsageExtensionField field = new KeyUsageExtensionField(true);
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

