/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.SignatureAlgorithmField;
import org.nhindirect.policy.x509.SignatureAlgorithmIdentifier;

public class SignatureAlgorithmField_injectReferenceValueTest {
    @Test
    public void testInjectReferenceValue_sha1RSA_assertAlgorithm() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        SignatureAlgorithmField field = new SignatureAlgorithmField();
        field.injectReferenceValue(cert);
        Assert.assertEquals((Object)SignatureAlgorithmIdentifier.SHA1RSA.getId(), (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectReferenceValue_sha256RSA_assertAlgorithm() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("CernerDirect DevCert Provider CA.der");
        SignatureAlgorithmField field = new SignatureAlgorithmField();
        field.injectReferenceValue(cert);
        Assert.assertEquals((Object)SignatureAlgorithmIdentifier.SHA256RSA.getId(), (Object)field.getPolicyValue().getPolicyValue());
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        SignatureAlgorithmField field = new SignatureAlgorithmField();
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

