/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.junit.Assert;
import org.junit.Test;
import org.nhindirect.policy.util.TestUtils;
import org.nhindirect.policy.x509.SubjectPublicKeyAlgorithmField;
import org.nhindirect.policy.x509.SubjectPublicKeySizeField;

public class SubjectPublicKeySizeField_injectReferenceValueTest {
    @Test
    public void testInjectRefereneValue_rsa1024_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("altNameOnly.der");
        SubjectPublicKeySizeField field = new SubjectPublicKeySizeField();
        field.injectReferenceValue(cert);
        int value = (Integer)field.getPolicyValue().getPolicyValue();
        Assert.assertEquals((long)1024L, (long)value);
    }

    @Test
    public void testInjectRefereneValue_rsa2024_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("umesh.der");
        SubjectPublicKeySizeField field = new SubjectPublicKeySizeField();
        field.injectReferenceValue(cert);
        int value = (Integer)field.getPolicyValue().getPolicyValue();
        Assert.assertEquals((long)2024L, (long)value);
    }

    @Test
    public void testInjectRefereneValue_dsa1024_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("dsa1024.der");
        SubjectPublicKeySizeField field = new SubjectPublicKeySizeField();
        field.injectReferenceValue(cert);
        int value = (Integer)field.getPolicyValue().getPolicyValue();
        Assert.assertEquals((long)1024L, (long)value);
    }

    @Test
    public void testInjectRefereneValue_ecc_assertValue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("ecc.der");
        SubjectPublicKeySizeField field = new SubjectPublicKeySizeField();
        field.injectReferenceValue(cert);
        int value = (Integer)field.getPolicyValue().getPolicyValue();
        Assert.assertEquals((long)0L, (long)value);
    }

    @Test
    public void testInjectRefereneValue_noInjection_getPolicyValue_assertException() throws Exception {
        SubjectPublicKeyAlgorithmField field = new SubjectPublicKeyAlgorithmField();
        boolean exceptionOccured = false;
        try {
            field.getPolicyValue();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assert.assertTrue((boolean)exceptionOccured);
    }
}

