/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.nhindirect.policy.Compiler;
import org.nhindirect.policy.ExecutionEngine;
import org.nhindirect.policy.Opcode;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.impl.machine.StackMachine;
import org.nhindirect.policy.impl.machine.StackMachineCompiler;

public class DefaultPolicyFilter
implements PolicyFilter {
    protected Compiler compiler = new StackMachineCompiler();
    protected ExecutionEngine executionEngine = new StackMachine();

    public void setCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    public void setExecutionEngine(ExecutionEngine executionEngine) {
        this.executionEngine = executionEngine;
    }

    @Override
    public boolean isCompliant(X509Certificate cert, InputStream policyStream, PolicyLexicon lexicon) throws PolicyProcessException {
        PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance(lexicon);
        PolicyExpression expression = parser.parse(policyStream);
        return this.isCompliant(cert, expression);
    }

    @Override
    public boolean isCompliant(X509Certificate cert, PolicyExpression expression) throws PolicyProcessException {
        if (this.compiler == null) {
            throw new IllegalStateException("Compiler cannot be null");
        }
        if (this.executionEngine == null) {
            throw new IllegalStateException("Execution engine cannot be null");
        }
        Vector<Opcode> opcodes = this.compiler.compile(cert, expression);
        return this.executionEngine.evaluate(opcodes);
    }
}

