/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.nhindirect.policy.BooleanPolicyOperatorExecutor;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;

public class UnaryBooleanPolicyOperatorExecutor<O>
implements BooleanPolicyOperatorExecutor<O> {
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    protected final PolicyValue<O> operand;
    protected final PolicyOperator operator;

    public UnaryBooleanPolicyOperatorExecutor(PolicyValue<O> operand, PolicyOperator operator) {
        if (!(operator.equals((Object)PolicyOperator.LOGICAL_NOT) || operator.equals((Object)PolicyOperator.URI_VALIDATE) || operator.equals((Object)PolicyOperator.EMPTY) || operator.equals((Object)PolicyOperator.NOT_EMPTY))) {
            throw new IllegalArgumentException("Operator " + operator.getOperatorText() + " is not allowed for this executor type.");
        }
        this.operand = operand;
        this.operator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyValue<Boolean> execute() {
        boolean retVal = false;
        switch (this.operator) {
            case LOGICAL_NOT: {
                retVal = !Boolean.parseBoolean(this.operand.getPolicyValue().toString());
                break;
            }
            case EMPTY: 
            case NOT_EMPTY: {
                Collection container = (Collection)Collection.class.cast(this.operand.getPolicyValue());
                retVal = this.operator.equals((Object)PolicyOperator.EMPTY) ? container.isEmpty() : !container.isEmpty();
                break;
            }
            case URI_VALIDATE: {
                InputStream inputStream = null;
                try {
                    String uri = (String)String.class.cast(this.operand.getPolicyValue());
                    URL certURL = new URL(uri);
                    URLConnection connection = certURL.openConnection();
                    connection.setConnectTimeout(10000);
                    connection.setReadTimeout(10000);
                    inputStream = connection.getInputStream();
                    int respCode = ((HttpURLConnection)connection).getResponseCode();
                    if (respCode >= 200 && respCode < 300) {
                        retVal = true;
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                    break;
                }
                catch (IOException e) {
                    retVal = false;
                    break;
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
            }
            default: {
                retVal = false;
            }
        }
        return PolicyValueFactory.getInstance(retVal);
    }
}

