/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.nhindirect.policy.Compiler;
import org.nhindirect.policy.LiteralPolicyExpression;
import org.nhindirect.policy.Opcode;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.ReferencePolicyExpression;
import org.nhindirect.policy.impl.machine.StackMachineEntry;
import org.nhindirect.policy.x509.X509Field;

public class StackMachineCompiler
implements Compiler {
    protected boolean reportModeEnabled = false;
    protected ThreadLocal<Collection<String>> compilerReport = new ThreadLocal();

    @Override
    public Vector<Opcode> compile(X509Certificate cert, PolicyExpression expression) throws PolicyProcessException {
        Collection<String> report = this.compilerReport.get();
        if (report != null) {
            report.clear();
        }
        Vector<Opcode> entries = new Vector<Opcode>();
        entries.add(this.compile(entries, cert, expression));
        return entries;
    }

    protected StackMachineEntry compile(Vector<Opcode> entries, X509Certificate cert, PolicyExpression expression) throws PolicyProcessException {
        switch (expression.getExpressionType()) {
            case LITERAL: {
                return new StackMachineEntry(((LiteralPolicyExpression)expression).getPolicyValue());
            }
            case REFERENCE: {
                ReferencePolicyExpression refExpression = (ReferencePolicyExpression)expression;
                this.evaluateReferenceExpression(cert, refExpression);
                return new StackMachineEntry(refExpression.getPolicyValue());
            }
            case OPERATION: {
                OperationPolicyExpression opExpression = (OperationPolicyExpression)expression;
                for (PolicyExpression polExpression : opExpression.getOperands()) {
                    entries.add(this.compile(entries, cert, polExpression));
                }
                return new StackMachineEntry(opExpression.getPolicyOperator());
            }
        }
        return null;
    }

    protected PolicyValue<?> evaluateReferenceExpression(X509Certificate cert, ReferencePolicyExpression<?, ?> expression) throws PolicyProcessException {
        switch (expression.getPolicyExpressionReferenceType()) {
            case STRUCT: 
            case CERTIFICATE: {
                return this.evaluateX509Field(cert, (X509Field)expression);
            }
        }
        return null;
    }

    protected PolicyValue<?> evaluateX509Field(X509Certificate cert, X509Field<?> expression) throws PolicyProcessException {
        try {
            expression.injectReferenceValue(cert);
            return expression.getPolicyValue();
        }
        catch (PolicyRequiredException e) {
            if (this.reportModeEnabled) {
                this.addErrorToReport(e);
                expression.setRequired(false);
                expression.injectReferenceValue(cert);
                return expression.getPolicyValue();
            }
            throw e;
        }
    }

    protected void addErrorToReport(PolicyProcessException e) {
        Collection<String> report = this.compilerReport.get();
        if (report == null) {
            report = new ArrayList<String>();
            this.compilerReport.set(report);
        }
        report.add(e.getMessage());
    }

    @Override
    public void setReportModeEnabled(boolean reportMode) {
        this.reportModeEnabled = reportMode;
    }

    @Override
    public boolean isReportModeEnabled() {
        return this.reportModeEnabled;
    }

    @Override
    public Collection<String> getCompilationReport() {
        Collection<String> report = this.compilerReport.get();
        if (report != null) {
            return Collections.unmodifiableCollection(report);
        }
        return Collections.emptyList();
    }
}

