/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLSequence;
import org.nhindirect.policy.PolicyExpressionReferenceType;
import org.nhindirect.policy.PolicyExpressionType;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.x509.X509Field;

public abstract class AbstractX509Field<P>
implements X509Field<P> {
    static final long serialVersionUID = 8705426787272691746L;
    protected transient PolicyValue<P> policyValue;
    protected transient X509Certificate certificate;
    protected boolean required;

    @Override
    public PolicyExpressionReferenceType getPolicyExpressionReferenceType() {
        return PolicyExpressionReferenceType.CERTIFICATE;
    }

    @Override
    public PolicyExpressionType getExpressionType() {
        return PolicyExpressionType.REFERENCE;
    }

    @Override
    public PolicyValue<P> getPolicyValue() {
        if (this.policyValue == null) {
            throw new IllegalStateException("Policy value is null");
        }
        return this.policyValue;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    protected ASN1Object getObject(byte[] ext) throws PolicyProcessException {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(octs.getOctets());
            aSN1Primitive = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new PolicyProcessException("Exception processing data ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return aSN1Primitive;
    }

    protected ASN1Object getDERObject(byte[] ext) throws PolicyProcessException {
        ASN1Primitive aSN1Primitive;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            DLSequence seq = (DLSequence)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(seq.getEncoded());
            aSN1Primitive = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new PolicyProcessException("Exception processing data ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return aSN1Primitive;
    }

    public String toString() {
        if (this.policyValue == null) {
            return "Unevaluated X509 field: " + this.getX509FieldType().toString();
        }
        return this.policyValue.toString();
    }
}

