/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;

public class CRLDistributionPointNameExtentionField
extends AbstractExtensionField<Collection<String>>
implements ExtensionField<Collection<String>> {
    static final long serialVersionUID = -6318762452965780915L;

    public CRLDistributionPointNameExtentionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        ASN1Object exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            List coll = Collections.emptyList();
            this.policyValue = PolicyValueFactory.getInstance(coll);
            return;
        }
        CRLDistPoint distPoints = CRLDistPoint.getInstance((Object)exValue);
        ArrayList<String> retVal = new ArrayList<String>();
        for (DistributionPoint distPoint : distPoints.getDistributionPoints()) {
            if (distPoint.getDistributionPoint() == null || distPoint.getDistributionPoint().getType() != 0) continue;
            GeneralNames names = GeneralNames.getInstance((Object)distPoint.getDistributionPoint().getName());
            for (GeneralName name : names.getNames()) {
                retVal.add(name.getName().toString());
            }
        }
        if (retVal.isEmpty() && this.isRequired()) {
            throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
        }
        this.policyValue = PolicyValueFactory.getInstance(retVal);
    }

    @Override
    public ExtensionIdentifier getExtentionIdentifier() {
        return ExtensionIdentifier.CRL_DISTRIBUTION_POINTS;
    }
}

