/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractTBSField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.TBSFieldName;

public class IssuerAttributeField
extends AbstractTBSField<Collection<String>> {
    static final long serialVersionUID = -8303963586265595510L;
    protected final RDNAttributeIdentifier rdnAttributeId;

    public IssuerAttributeField(boolean required, RDNAttributeIdentifier rdnAttributeId) {
        super(required);
        this.rdnAttributeId = rdnAttributeId;
    }

    @Override
    public TBSFieldName getFieldName() {
        return TBSFieldName.ISSUER;
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        if (this.rdnAttributeId.equals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME)) {
            List<String> str = Arrays.asList(this.certificate.getIssuerX500Principal().getName("RFC2253"));
            this.policyValue = PolicyValueFactory.getInstance(str);
            return;
        }
        ASN1Object tbsValue = null;
        try {
            tbsValue = this.getDERObject(this.certificate.getTBSCertificate());
        }
        catch (Exception e) {
            throw new PolicyProcessException("Exception parsing TBS certificate fields.", e);
        }
        TBSCertificate tbsStruct = TBSCertificate.getInstance((Object)tbsValue);
        X500Name x500Name = this.getX509Name(tbsStruct);
        RDN[] values = x500Name.getRDNs((ASN1ObjectIdentifier)new DERObjectIdentifier(this.getRDNAttributeFieldId().getId()));
        if (values.length == 0 && this.isRequired()) {
            throw new PolicyRequiredException((Object)((Object)this.getFieldName()) + " field attribute " + this.rdnAttributeId.getName() + " is marked as required but is not present.");
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (RDN rds : values) {
            for (AttributeTypeAndValue val : rds.getTypesAndValues()) {
                retVal.add(val.getValue().toString());
            }
        }
        this.policyValue = PolicyValueFactory.getInstance(retVal);
    }

    protected X500Name getX509Name(TBSCertificate tbsStruct) {
        return tbsStruct.getIssuer();
    }

    public RDNAttributeIdentifier getRDNAttributeFieldId() {
        return this.rdnAttributeId;
    }
}

