/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.ExtensionIdentifier;
import org.nhindirect.policy.x509.GeneralNameType;

public class SubjectAltNameExtensionField
extends AbstractExtensionField<Collection<String>>
implements ExtensionField<Collection<String>> {
    private static final long serialVersionUID = -5981093598324156863L;

    public SubjectAltNameExtensionField(boolean required) {
        super(required);
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        ASN1Object exValue = this.getExtensionValue(value);
        if (exValue == null) {
            if (this.isRequired()) {
                throw new PolicyRequiredException("Extention " + this.getExtentionIdentifier().getDisplay() + " is marked as required by is not present.");
            }
            List emptyList = Collections.emptyList();
            this.policyValue = PolicyValueFactory.getInstance(emptyList);
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        GeneralNames generalNames = GeneralNames.getInstance((Object)exValue);
        for (GeneralName name : generalNames.getNames()) {
            GeneralNameType type = GeneralNameType.fromTag(name.getTagNo());
            if (type == null) continue;
            names.add(type.getDisplay() + ":" + name.getName().toString());
        }
        this.policyValue = PolicyValueFactory.getInstance(names);
    }

    @Override
    public ExtensionIdentifier getExtentionIdentifier() {
        return ExtensionIdentifier.SUBJECT_ALT_NAME;
    }
}

