/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.x509.AbstractTBSField;
import org.nhindirect.policy.x509.TBSFieldName;

public class SubjectPublicKeyAlgorithmField
extends AbstractTBSField<String> {
    static final long serialVersionUID = -1094029946830031432L;

    public SubjectPublicKeyAlgorithmField() {
        super(true);
    }

    @Override
    public TBSFieldName getFieldName() {
        return TBSFieldName.SUBJECT_PUBLIC_KEY_INFO;
    }

    @Override
    public void injectReferenceValue(X509Certificate value) throws PolicyProcessException {
        this.certificate = value;
        ASN1Object tbsValue = null;
        try {
            tbsValue = this.getDERObject(this.certificate.getTBSCertificate());
        }
        catch (Exception e) {
            throw new PolicyProcessException("Exception parsing TBS certificate fields.", e);
        }
        TBSCertificate tbsStruct = TBSCertificate.getInstance((Object)tbsValue);
        this.policyValue = PolicyValueFactory.getInstance(tbsStruct.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().toString());
    }
}

