/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyFilterFactory;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.util.TestUtils;

public class PolicyFilter_textConversionToIntegerComplianceTest {
    @Test
    public void testCompliance_simpleTextLexicon_equalsIntegerCertValue_assertTrue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"X509.TBS.EXTENSION.KeyUsage = 224");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_notEqualsIntegerCertValue_assertTrue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"X509.TBS.EXTENSION.KeyUsage != 223");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_lessThanAndGreaterThanIntegerCertValue_assertTrue() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"(X509.TBS.EXTENSION.KeyUsage > 0) && (X509.TBS.EXTENSION.KeyUsage < 225)");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_bitWiseAndIntegerCertValue_assertEquals() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"(X509.TBS.EXTENSION.KeyUsage & 224) = 224");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_bitWiseAndIntegerCertValue_assertNotEquals() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"(X509.TBS.EXTENSION.KeyUsage & 200) != 224");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_bitWiseOrIntegerCertValue_assertEquals() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"(X509.TBS.EXTENSION.KeyUsage | 0) = 224");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }

    @Test
    public void testCompliance_simpleTextLexicon_bitWiseOrIntegerCertValue_assertNotEquals() throws Exception {
        X509Certificate cert = TestUtils.loadCertificate("AlAnderson@hospitalA.direct.visionshareinc.com.der");
        InputStream stream = IOUtils.toInputStream((String)"(X509.TBS.EXTENSION.KeyUsage | 255) != 224");
        PolicyFilter filter = PolicyFilterFactory.getInstance();
        Assertions.assertTrue((boolean)filter.isCompliant(cert, stream, PolicyLexicon.SIMPLE_TEXT_V1));
    }
}

