/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.impl.BinaryBooleanPolicyOperatorExecutor;

public class BinaryBooleanPolicyOperatorExecutor_executeTest {
    @Test
    public void testExecute_logicalAnd_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)true);
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)true);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)false);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_logicalAnd_stringArguments_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"true");
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)"true");
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"true");
        op2 = PolicyValueFactory.getInstance((Object)"false");
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"false");
        op2 = PolicyValueFactory.getInstance((Object)"false");
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_AND);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_logicalOr_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)true);
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_OR);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)true);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_OR);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)false);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.LOGICAL_OR);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_equals_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)true);
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.EQUALS);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)true);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.EQUALS);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        PolicyValue opInt1 = PolicyValueFactory.getInstance((Object)123);
        PolicyValue opInt2 = PolicyValueFactory.getInstance((Object)123);
        BinaryBooleanPolicyOperatorExecutor intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.EQUALS);
        Assertions.assertTrue((boolean)((Boolean)intOperator.execute().getPolicyValue()));
        opInt1 = PolicyValueFactory.getInstance((Object)123);
        opInt2 = PolicyValueFactory.getInstance((Object)456);
        intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.EQUALS);
        Assertions.assertFalse((boolean)((Boolean)intOperator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_notEquals_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)true);
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.NOT_EQUALS);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)true);
        op2 = PolicyValueFactory.getInstance((Object)false);
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.NOT_EQUALS);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        PolicyValue opInt1 = PolicyValueFactory.getInstance((Object)123);
        PolicyValue opInt2 = PolicyValueFactory.getInstance((Object)123);
        BinaryBooleanPolicyOperatorExecutor intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.NOT_EQUALS);
        Assertions.assertFalse((boolean)((Boolean)intOperator.execute().getPolicyValue()));
        opInt1 = PolicyValueFactory.getInstance((Object)123);
        opInt2 = PolicyValueFactory.getInstance((Object)456);
        intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.NOT_EQUALS);
        Assertions.assertTrue((boolean)((Boolean)intOperator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_greater_assertResults() {
        PolicyValue opInt1 = PolicyValueFactory.getInstance((Object)5);
        PolicyValue opInt2 = PolicyValueFactory.getInstance((Object)4);
        BinaryBooleanPolicyOperatorExecutor intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.GREATER);
        Assertions.assertFalse((boolean)((Boolean)intOperator.execute().getPolicyValue()));
        opInt1 = PolicyValueFactory.getInstance((Object)4);
        opInt2 = PolicyValueFactory.getInstance((Object)5);
        intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.GREATER);
        Assertions.assertTrue((boolean)((Boolean)intOperator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_less_assertResults() {
        PolicyValue opInt1 = PolicyValueFactory.getInstance((Object)4);
        PolicyValue opInt2 = PolicyValueFactory.getInstance((Object)5);
        BinaryBooleanPolicyOperatorExecutor intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.LESS);
        Assertions.assertFalse((boolean)((Boolean)intOperator.execute().getPolicyValue()));
        opInt1 = PolicyValueFactory.getInstance((Object)5);
        opInt2 = PolicyValueFactory.getInstance((Object)4);
        intOperator = new BinaryBooleanPolicyOperatorExecutor(opInt1, opInt2, PolicyOperator.LESS);
        Assertions.assertTrue((boolean)((Boolean)intOperator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_contains_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"689");
        PolicyValue op2 = PolicyValueFactory.getInstance(Arrays.asList("123", "456", "689"));
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.CONTAINS);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"777");
        op2 = PolicyValueFactory.getInstance(Arrays.asList("123", "456", "689"));
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.CONTAINS);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_notContains_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"689");
        PolicyValue op2 = PolicyValueFactory.getInstance(Arrays.asList("123", "456", "689"));
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.NOT_CONTAINS);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"777");
        op2 = PolicyValueFactory.getInstance(Arrays.asList("123", "456", "689"));
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.NOT_CONTAINS);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_containsRegEx_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"http");
        PolicyValue op2 = PolicyValueFactory.getInstance(Arrays.asList("http://thisis.aurl.com"));
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.CONTAINS_REG_EX);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"777");
        op2 = PolicyValueFactory.getInstance(Arrays.asList("http://thisis.aurl.com"));
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.CONTAINS_REG_EX);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_regEx_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"http");
        PolicyValue op2 = PolicyValueFactory.getInstance((Object)"http://thisis.aurl.com");
        BinaryBooleanPolicyOperatorExecutor operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.REG_EX);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"777");
        op2 = PolicyValueFactory.getInstance((Object)"http://thisis.aurl.com");
        operator = new BinaryBooleanPolicyOperatorExecutor(op1, op2, PolicyOperator.REG_EX);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }
}

