/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.nhindirect.policy.Compiler;
import org.nhindirect.policy.ExecutionEngine;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.impl.DefaultPolicyFilter;

public class DefaultPolicyFilter_isCompliantTest {
    @Test
    public void testIsCompliant_parse_engineReturnsCompliant_assertTrue() throws Exception {
        FileInputStream inStream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/dataEnciphermentOnlyRequired.xml"));
        Compiler compiler = (Compiler)Mockito.mock(Compiler.class);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)engine.evaluate((Vector)ArgumentMatchers.any())).thenReturn((Object)Boolean.TRUE);
        DefaultPolicyFilter filter = new DefaultPolicyFilter();
        filter.setCompiler(compiler);
        filter.setExecutionEngine(engine);
        Assertions.assertTrue((boolean)filter.isCompliant(cert, (InputStream)inStream, PolicyLexicon.XML));
    }

    @Test
    public void testIsCompliant_engineReturnsCompliant_assertTrue() throws Exception {
        Compiler compiler = (Compiler)Mockito.mock(Compiler.class);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)engine.evaluate((Vector)ArgumentMatchers.any())).thenReturn((Object)Boolean.TRUE);
        DefaultPolicyFilter filter = new DefaultPolicyFilter();
        filter.setCompiler(compiler);
        filter.setExecutionEngine(engine);
        Assertions.assertTrue((boolean)filter.isCompliant(cert, expression));
    }

    @Test
    public void testIsCompliant_engineReturnsNotCompliant_assertFalse() throws Exception {
        Compiler compiler = (Compiler)Mockito.mock(Compiler.class);
        ExecutionEngine engine = (ExecutionEngine)Mockito.mock(ExecutionEngine.class);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        Mockito.when((Object)engine.evaluate((Vector)ArgumentMatchers.any())).thenReturn((Object)Boolean.FALSE);
        DefaultPolicyFilter filter = new DefaultPolicyFilter();
        filter.setCompiler(compiler);
        filter.setExecutionEngine(engine);
        Assertions.assertFalse((boolean)filter.isCompliant(cert, expression));
    }

    @Test
    public void testIsCompliant_missingComplier_assertException() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        DefaultPolicyFilter filter = new DefaultPolicyFilter();
        filter.setCompiler(null);
        boolean exceptionOccured = false;
        try {
            Assertions.assertFalse((boolean)filter.isCompliant(cert, expression));
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testIsCompliant_missingEngine_assertException() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        DefaultPolicyFilter filter = new DefaultPolicyFilter();
        filter.setExecutionEngine(null);
        boolean exceptionOccured = false;
        try {
            Assertions.assertFalse((boolean)filter.isCompliant(cert, expression));
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

