/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.LiteralPolicyExpression;
import org.nhindirect.policy.OperationPolicyExpression;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyExpressionType;
import org.nhindirect.policy.PolicyGrammarException;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;
import org.nhindirect.policy.x509.KeyUsageExtensionField;
import org.nhindirect.policy.x509.SubjectAttributeField;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;
import org.nhindirect.policy.x509.X509Field;

public class SimpleTextV1LexiconPolicyParser_buildExpressionTest {
    @Test
    public void testBuildExpression_simpleExpression_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/simpleLexiconSamp1.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_AND, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression param1operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)param1operationExpression.getPolicyOperator());
        expression = (PolicyExpression)param1operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"1", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        expression = (PolicyExpression)param1operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"2", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression param2operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.NOT_EQUALS, (Object)param2operationExpression.getPolicyOperator());
        expression = (PolicyExpression)param2operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"2", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        expression = (PolicyExpression)param2operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"1", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_x509FieldsType_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/lexiconWithCertificateStruct.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.REFERENCE, (Object)expression.getExpressionType());
        Assertions.assertTrue((boolean)(expression instanceof X509Field));
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"1.2.840.113549.1.1.11", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_tbsFieldName_rdnAttribute_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/literalWithSpaces.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.REFERENCE, (Object)expression.getExpressionType());
        Assertions.assertTrue((boolean)(expression instanceof SubjectAttributeField));
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"United States", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_extensionName_keyUsage_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/lexiconWithKeyUsage.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.REFERENCE, (Object)expression.getExpressionType());
        Assertions.assertTrue((boolean)(expression instanceof KeyUsageExtensionField));
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"1", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_tinaryExpression_literalOperands_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"2 = 1 != true");
        Vector tokens = parser.parseToTokens(stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.NOT_EQUALS, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"true", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression subOperation = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)subOperation.getPolicyOperator());
        expression = (PolicyExpression)subOperation.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"2", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        expression = (PolicyExpression)subOperation.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"1", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_tinaryExpression_operatorExpressionOperands_validatePolicyExpression() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"false = !true && !false");
        Vector tokens = parser.parseToTokens(stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_AND, (Object)operationExpression.getPolicyOperator());
        OperationPolicyExpression subOperation = (OperationPolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)subOperation.getExpressionType());
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)subOperation.getPolicyOperator());
        expression = (PolicyExpression)subOperation.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"false", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
        OperationPolicyExpression subSubOperation = (OperationPolicyExpression)subOperation.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)subSubOperation.getExpressionType());
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_NOT, (Object)subSubOperation.getPolicyOperator());
        subOperation = (OperationPolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)subOperation.getExpressionType());
        Assertions.assertEquals((Object)PolicyOperator.LOGICAL_NOT, (Object)subOperation.getPolicyOperator());
        expression = (PolicyExpression)subOperation.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        Assertions.assertEquals((Object)"false", (Object)((LiteralPolicyExpression)expression).getPolicyValue().getPolicyValue());
    }

    @Test
    public void testBuildExpression_requiredCertField_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"X509.TBS.EXTENSION.SubjectKeyIdentifier+ = 1.3.2.3");
        Vector tokens = parser.parseToTokens(stream);
        PolicyExpression expression = parser.buildExpression(tokens.iterator());
        Assertions.assertNotNull((Object)expression);
        Assertions.assertEquals((Object)PolicyExpressionType.OPERATION, (Object)expression.getExpressionType());
        OperationPolicyExpression operationExpression = (OperationPolicyExpression)expression;
        Assertions.assertEquals((Object)PolicyOperator.EQUALS, (Object)operationExpression.getPolicyOperator());
        expression = (PolicyExpression)operationExpression.getOperands().get(0);
        Assertions.assertEquals((Object)PolicyExpressionType.REFERENCE, (Object)expression.getExpressionType());
        Assertions.assertTrue((boolean)(expression instanceof SubjectKeyIdentifierExtensionField));
        Assertions.assertTrue((boolean)((SubjectKeyIdentifierExtensionField)expression).isRequired());
        expression = (PolicyExpression)operationExpression.getOperands().get(1);
        Assertions.assertEquals((Object)PolicyExpressionType.LITERAL, (Object)expression.getExpressionType());
        stream.close();
    }

    @Test
    public void testBuildExpression_toManyClosingParenthesis_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"(2 = 1) != true)");
        Vector tokens = parser.parseToTokens(stream);
        boolean exceptionOccured = false;
        try {
            parser.buildExpression(tokens.iterator());
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        stream.close();
    }

    @Test
    public void testBuildExpression_binaryOperation_missingParameter_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"&& true");
        Vector tokens = parser.parseToTokens(stream);
        boolean exceptionOccured = false;
        try {
            parser.buildExpression(tokens.iterator());
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        stream.close();
    }

    @Test
    public void testBuildExpression_operation_missingSingleParameter_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"&&");
        Vector tokens = parser.parseToTokens(stream);
        boolean exceptionOccured = false;
        try {
            parser.buildExpression(tokens.iterator());
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        stream.close();
    }

    @Test
    public void testBuildExpression_emptyGroup_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"()");
        Vector tokens = parser.parseToTokens(stream);
        boolean exceptionOccured = false;
        try {
            parser.buildExpression(tokens.iterator());
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExpression_erroniousExpressionAtEnd_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"((d = 1)) +");
        Vector tokens = parser.parseToTokens(stream);
        boolean exceptionOccured = false;
        try {
            parser.buildExpression(tokens.iterator());
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

