/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;
import org.nhindirect.policy.x509.AuthorityInfoAccessExtentionField;
import org.nhindirect.policy.x509.AuthorityInfoAccessOCSPLocExtentionField;
import org.nhindirect.policy.x509.AuthorityKeyIdentifierKeyIdExtensionField;
import org.nhindirect.policy.x509.BasicContraintsExtensionField;
import org.nhindirect.policy.x509.CRLDistributionPointNameExtentionField;
import org.nhindirect.policy.x509.CertificatePolicyCpsUriExtensionField;
import org.nhindirect.policy.x509.CertificatePolicyIndentifierExtensionField;
import org.nhindirect.policy.x509.ExtendedKeyUsageExtensionField;
import org.nhindirect.policy.x509.ExtensionField;
import org.nhindirect.policy.x509.KeyUsageExtensionField;
import org.nhindirect.policy.x509.SubjectAltNameExtensionField;
import org.nhindirect.policy.x509.SubjectKeyIdentifierExtensionField;

public class SimpleTextV1LexiconPolicyParser_buildExtensionFieldTest {
    @Test
    public void testBuildExtensionField_keyUsage_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.KeyUsage"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof KeyUsageExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.KeyUsage+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof KeyUsageExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_subjectAltName_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectAltName"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAltNameExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectAltName+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAltNameExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_subjectDirectoryAttributes_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectDirectoryAttributes");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectDirectoryAttributes+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_subjectKeyIdentifier_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectKeyIdentifier"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectKeyIdentifierExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.SubjectKeyIdentifier+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectKeyIdentifierExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_issuierAltName_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.IssuerAltName");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.IssuerAltName+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_autorityKeyId_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.KeyId"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityKeyIdentifierKeyIdExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.KeyId+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityKeyIdentifierKeyIdExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.CertIssuers");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.CertIssuers+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.SerialNumber");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityKeyIdentifier.SerialNumber+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_certificatePolicies_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.PolicyOIDs"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CertificatePolicyIndentifierExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.PolicyOIDs+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CertificatePolicyIndentifierExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.CPSUrls"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CertificatePolicyCpsUriExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CertificatePolicies.CPSUrls+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CertificatePolicyCpsUriExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_policyMappings_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyMappings");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyMappings+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_basicContraints_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.CA"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof BasicContraintsExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.CA+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof BasicContraintsExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.MaxPathLength");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.BasicConstraints.MaxPathLength+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_nameConstraints_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.NameConstraints");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.NameConstraints+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_policyConstraints_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyConstraints");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.PolicyConstraints+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_extendedKeyUsage_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.ExtKeyUsageSyntax"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof ExtendedKeyUsageExtensionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.ExtKeyUsageSyntax+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof ExtendedKeyUsageExtensionField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildExtensionField_crlDispPoints_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.FullName"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CRLDistributionPointNameExtentionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.FullName+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof CRLDistributionPointNameExtentionField));
        Assertions.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.RelativeToIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.RelativeToIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.Reasons");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.Reasons+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.CRLIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.CRLDistributionPoints.CRLIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_inhibitAnyPolicy_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.InhibitAnyPolicy");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.InhibitAnyPolicy+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_freshestCRL_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.FullName");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.FullName+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.RelativeToIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.RelativeToIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.Reasons");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.Reasons+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.CRLIssuer");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.FreshestCRL.CRLIssuer+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_auhtorityInformationAccess_assertFields() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.Url"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityInfoAccessExtentionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.Url+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityInfoAccessExtentionField));
        Assertions.assertTrue((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.OCSPLocation"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityInfoAccessOCSPLocExtentionField));
        Assertions.assertFalse((boolean)field.isRequired());
        field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.OCSPLocation+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof AuthorityInfoAccessOCSPLocExtentionField));
        Assertions.assertTrue((boolean)field.isRequired());
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.AccessMethod");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.AuthorityInfoAccessSyntax.AccessMethod+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_auhtorityInformationAccess_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.Url");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.Url+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.AccessMethod");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.AccessMethod+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.OCSPLocation");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            parser.buildExtensionField("X509.TBS.EXTENSION.SubjectInfoAccessSyntax.OCSPLocation+");
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildExtensionField_unknownField_assertNull() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        ExtensionField field = (ExtensionField)ExtensionField.class.cast(parser.buildExtensionField("X509.TBS.EXTENSION.Bogus"));
        Assertions.assertNull((Object)field);
    }
}

