/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.SerialNumberAttributeField;
import org.nhindirect.policy.x509.SubjectAttributeField;
import org.nhindirect.policy.x509.SubjectPublicKeyAlgorithmField;
import org.nhindirect.policy.x509.SubjectPublicKeySizeField;
import org.nhindirect.policy.x509.TBSField;

public class SimpleTextV1LexiconPolicyParser_buildTBSFieldTest {
    @Test
    public void testBuildTBSField_version_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Version"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_serialNumber_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SerialNumber"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SerialNumberAttributeField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_signature_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Signature"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Signature+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_issuer_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.CN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.CN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.C"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.C+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.O"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.O+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.OU"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.OU+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.ST"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.ST+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.L"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.L+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.E"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.E+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DC"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DC+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DNQUALIFIER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DNQUALIFIER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SERIALNUMBER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SERIALNUMBER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.SN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.TITLE"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.TITLE+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GIVENNAME"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GIVENNAME+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.INITIALS"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.INITIALS+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.PSEUDONYM"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.PSEUDONYM+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GERNERAL_QUALIFIER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.GERNERAL_QUALIFIER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Issuer.DN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof IssuerAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((IssuerAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_validity_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidFrom"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidFrom+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidTo"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.Validity.ValidTo+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subject_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.CN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.CN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COMMON_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.C"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.C+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.COUNTRY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.O"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.O+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATION, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.OU"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.OU+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.ORGANIZATIONAL_UNIT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.ST"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.ST+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.STATE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.L"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.L+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.LOCALITY, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.E"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.E+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.EMAIL, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DC"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DC+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DOMAIN_COMPONENT, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DNQUALIFIER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DNQUALIFIER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SERIALNUMBER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SERIALNUMBER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SERIAL_NUMBER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.SN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.SURNAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.TITLE"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.TITLE+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.TITLE, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GIVENNAME"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GIVENNAME+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GIVEN_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.INITIALS"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.INITIALS+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.INITIALS, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.PSEUDONYM"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.PSEUDONYM+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.PSEUDONYM, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GERNERAL_QUALIFIER"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.GERNERAL_QUALIFIER+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.GERNERAL_QUALIFIER, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DN"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertFalse((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Subject.DN+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectAttributeField));
        Assertions.assertEquals((Object)RDNAttributeIdentifier.DISTINGUISHED_NAME, (Object)((SubjectAttributeField)field).getRDNAttributeFieldId());
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_issuerUniqueId_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.IssuerUniqueID"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.IssuerUniqueID+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subjectUniqueId_assertFieldNotImplemented() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        boolean exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectUniqueID"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
        exceptionOccured = false;
        try {
            TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectUniqueID+"));
        }
        catch (PolicyParseException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testBuildTBSField_subjectPublicKeyInfo_assertBuilt() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Algorithm"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectPublicKeyAlgorithmField));
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Algorithm+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectPublicKeyAlgorithmField));
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Size"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectPublicKeySizeField));
        Assertions.assertTrue((boolean)field.isRequired());
        field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.SubjectPublicKeyInfo.Size+"));
        Assertions.assertNotNull((Object)field);
        Assertions.assertTrue((boolean)(field instanceof SubjectPublicKeySizeField));
        Assertions.assertTrue((boolean)field.isRequired());
    }

    @Test
    public void testBuildTBSField_unknownField_assertNull() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        TBSField field = (TBSField)TBSField.class.cast(parser.buildTBSField("X509.TBS.Bugos"));
        Assertions.assertNull((Object)field);
    }
}

