/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyGrammarException;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;

public class SimpleTextV1LexiconPolicyParser_parseTest {
    @Test
    public void testParse_simpleExpression_validateParsed() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/simpleLexiconSamp1.txt"));
        PolicyExpression expressions = parser.parse((InputStream)stream);
        Assertions.assertNotNull((Object)expressions);
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_unclosedGroup_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"(1 = 1");
        boolean exceptionOccured = false;
        try {
            parser.parse(stream);
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testParse_noOperator_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"1");
        boolean exceptionOccured = false;
        try {
            parser.parse(stream);
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }

    @Test
    public void testParse_extraniousOperator_assertGrammarException() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"1 = 1 =");
        boolean exceptionOccured = false;
        try {
            parser.parse(stream);
        }
        catch (PolicyGrammarException e) {
            exceptionOccured = true;
        }
        Assertions.assertTrue((boolean)exceptionOccured);
    }
}

