/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.impl.SimpleTextV1LexiconPolicyParser;

public class SimpleTextV1LexiconPolicyParser_parseToTokensTest {
    @Test
    public void testParse_simpleExpression_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/simpleLexiconSamp1.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assertions.assertEquals((int)11, (int)tokens.size());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_logicalAndOperator_validateSingleTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/logicalAndOperator.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assertions.assertEquals((int)1, (int)tokens.size());
        Assertions.assertEquals((Object)"&&", (Object)((SimpleTextV1LexiconPolicyParser.TokenTypeAssociation)tokens.iterator().next()).getToken());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_CertificateStruct_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/lexiconWithCertificateStruct.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assertions.assertEquals((int)3, (int)tokens.size());
        Assertions.assertEquals((Object)SimpleTextV1LexiconPolicyParser.TokenType.CERTIFICATE_REFERENCE_EXPRESSION, (Object)((SimpleTextV1LexiconPolicyParser.TokenTypeAssociation)tokens.iterator().next()).getType());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_literalWithSpaces_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        FileInputStream stream = FileUtils.openInputStream((File)new File("./src/test/resources/policies/literalWithSpaces.txt"));
        Vector tokens = parser.parseToTokens((InputStream)stream);
        Assertions.assertEquals((int)3, (int)tokens.size());
        ((InputStream)stream).close();
    }

    @Test
    public void testParse_requiredCertField_validateTokens() throws Exception {
        SimpleTextV1LexiconPolicyParser parser = new SimpleTextV1LexiconPolicyParser();
        InputStream stream = IOUtils.toInputStream((String)"X509.TBS.EXTENSION.SubjectKeyIdentifier+ = 1.3.2.3");
        Vector tokens = parser.parseToTokens(stream);
        Assertions.assertEquals((int)3, (int)tokens.size());
        stream.close();
    }
}

