/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.PolicyValueFactory;
import org.nhindirect.policy.impl.UnaryBooleanPolicyOperatorExecutor;
import org.nhindirect.policy.mock.SpringBaseTest;

public class UnaryBooleanPolicyOperatorExecutor_executeTest
extends SpringBaseTest {
    @Test
    public void testExecute_logicalNot_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)true);
        UnaryBooleanPolicyOperatorExecutor operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.LOGICAL_NOT);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)false);
        operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.LOGICAL_NOT);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_empty_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance(Arrays.asList("A"));
        UnaryBooleanPolicyOperatorExecutor operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.EMPTY);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance(Arrays.asList(new String[0]));
        operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.EMPTY);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_notEmpty_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance(Arrays.asList("A"));
        UnaryBooleanPolicyOperatorExecutor operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.NOT_EMPTY);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance(Arrays.asList(new String[0]));
        operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.NOT_EMPTY);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }

    @Test
    public void testExecute_uriValidate_assertResults() {
        PolicyValue op1 = PolicyValueFactory.getInstance((Object)"http://localhost:8080/cps");
        UnaryBooleanPolicyOperatorExecutor operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.URI_VALIDATE);
        Assertions.assertTrue((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"http://www.google.com/333333");
        operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.URI_VALIDATE);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
        op1 = PolicyValueFactory.getInstance((Object)"http://bogus.unit.test.ccc");
        operator = new UnaryBooleanPolicyOperatorExecutor(op1, PolicyOperator.URI_VALIDATE);
        Assertions.assertFalse((boolean)((Boolean)operator.execute().getPolicyValue()));
    }
}

